% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_activity_streams.R
\name{get_activity_streams}
\alias{get_activity_streams}
\alias{get_activity_streams.list}
\alias{get_activity_streams.actframe}
\title{Retrieve streams for activities, and convert to a dataframe}
\usage{
get_activity_streams(act_data, ...)

\method{get_activity_streams}{list}(
  act_data,
  stoken,
  acts = NULL,
  id = NULL,
  types = NULL,
  resolution = "high",
  series_type = "distance",
  ...
)

\method{get_activity_streams}{actframe}(
  act_data,
  stoken,
  types = NULL,
  resolution = "high",
  series_type = "distance",
  ...
)
}
\arguments{
\item{act_data}{an \code{list} object returned by \code{\link{get_activity_list}} or a \code{data.frame} returned by \code{\link{compile_activities}}}

\item{...}{arguments passed to or from other methods}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{acts}{numeric indicating which activities to compile starting with most recent, defaults to all}

\item{id}{optional numeric vector to specify the id(s) of the activity/activities to plot, \code{acts} is ignored if provided}

\item{types}{list indicating which streams to get for each activity, defaults to all available, see details.}

\item{resolution}{chr string for the data resolution to retrieve, can be "low", "medium", "high", defaults to all}

\item{series_type}{chr string for merging the data if \code{resolution} is not equal to "all". Accepted values are "distance" (default) or "time".}
}
\value{
A stream frame object (\code{strframe} that includes a data frame for the stream data along with the units
}
\description{
Retrieve streams for activities, and convert to a dataframe.
}
\details{
Each activity has a value for every column present across all activities, with NAs populating missing values.

For the \code{types} argument, the default is \code{type = NULL} which will retrieve all available stream types.  The available stream types can be any of \code{time}, \code{latlng}, \code{distance}, \code{altitude}, \code{velocity_smooth}, \code{heartrate}, \code{cadence}, \code{watts}, \code{temp}, \code{moving}, or \code{grade_smooth}.  To retrieve only a subset of the types, pass a list argument with the appropriate character strings to \code{type}, e.g., \code{type = list("time", "latlng", "distance")}.
}
\examples{
 
\dontrun{
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))

my_acts <- get_activity_list(stoken) 

strms_data <- get_activity_streams(my_acts, stoken, acts = 1:2)

}
}
\author{
Lorenzo Gaborini
}
\concept{token}
