% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gear.R
\name{get_gear}
\alias{get_gear}
\title{Get gear details from its identifier}
\usage{
get_gear(id, stoken)
}
\arguments{
\item{id}{string, identifier of the equipment item}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}
}
\value{
Data from an API request.
}
\description{
Get gear details from its identifier
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_gear("2275365", stoken)
}
}
\concept{token}
