/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyGenerator$PyExposer;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTraceback;
import org.python.core.PyType;
import org.python.expose.ExposedType;

@ExposedType(name="generator", base=PyObject.class, isBaseType=false)
public class PyGenerator
extends PyIterator {
    protected PyFrame gi_frame;
    protected boolean gi_running;
    private PyException generatorExit;
    private PyObject closure;

    public PyGenerator(PyFrame frame, PyObject closure) {
        this.gi_frame = frame;
        this.closure = closure;
        this.generatorExit = Py.makeException(Py.GeneratorExit);
    }

    public PyObject send(PyObject value) {
        if (this.gi_frame == null) {
            throw Py.StopIteration("");
        }
        if (this.gi_frame.f_lasti == 0 && value != Py.None) {
            throw Py.TypeError("can't send non-None value to a just-started generator");
        }
        this.gi_frame.setGeneratorInput(value);
        return this.next();
    }

    public PyObject throw$(PyObject type, PyObject value, PyObject tb) {
        if (tb == Py.None) {
            tb = null;
        } else if (tb != null && !(tb instanceof PyTraceback)) {
            throw Py.TypeError("throw() third argument must be a traceback object");
        }
        return this.raiseException(Py.makeException(type, value, tb));
    }

    public PyObject close() {
        try {
            this.raiseException(this.generatorExit);
            throw Py.RuntimeError("generator ignored GeneratorExit");
        }
        catch (PyException e) {
            if (e.type != Py.StopIteration && e.type != Py.GeneratorExit) {
                throw e;
            }
            return Py.None;
        }
    }

    public PyObject next() {
        return super.next();
    }

    public PyObject __iter__() {
        return this;
    }

    private PyObject raiseException(PyException ex) {
        if (this.gi_frame == null || this.gi_frame.f_lasti == 0) {
            throw ex;
        }
        this.gi_frame.setGeneratorInput(ex);
        return this.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.gi_frame == null || this.gi_frame.f_lasti == -1) {
            return;
        }
        try {
            this.close();
        }
        catch (PyException e) {
            String className = PyException.exceptionClassName(e.type);
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                className = className.substring(lastDot + 1);
            }
            String msg = String.format("Exception %s: %s in %s", className, e.value.__repr__().toString(), this.__repr__().toString());
            Py.println(Py.getSystemState().stderr, Py.newString(msg));
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject __iternext__() {
        if (this.gi_running) {
            throw Py.ValueError("generator already executing");
        }
        if (this.gi_frame == null) {
            return null;
        }
        if (this.gi_frame.f_lasti == -1) {
            this.gi_frame = null;
            return null;
        }
        this.gi_running = true;
        PyObject result = null;
        try {
            result = this.gi_frame.f_code.call(this.gi_frame, this.closure);
        }
        catch (PyException e) {
            if (e.type != Py.StopIteration && e.type != Py.GeneratorExit) {
                this.gi_frame = null;
                throw e;
            }
            this.stopException = e;
            this.gi_frame = null;
            PyObject pyObject = null;
            return pyObject;
        }
        finally {
            this.gi_running = false;
        }
        if (result == Py.None && this.gi_frame.f_lasti == -1) {
            return null;
        }
        return result;
    }

    static {
        PyType.addBuilder(PyGenerator.class, new PyGenerator$PyExposer());
    }
}

