/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import org.python.constantine.platform.Errno;
import org.python.core.Py;
import org.python.core.imp;
import org.python.core.io.RawIOBase;
import org.python.core.util.RelativeFile;

public class FileIO
extends RawIOBase {
    private FileChannel fileChannel;
    private RandomAccessFile file;
    private boolean reading = false;
    private boolean writing = false;
    private boolean appending = false;
    private boolean plus = false;

    public FileIO(String name, String mode) {
        this.parseMode(mode);
        RelativeFile fullPath = new RelativeFile(name);
        String rafMode = "r" + (this.writing ? "w" : "");
        try {
            if (this.plus && this.reading && !fullPath.isFile()) {
                this.writing = false;
                throw new FileNotFoundException("");
            }
            this.file = new RandomAccessFile(fullPath, rafMode);
            this.fileChannel = this.file.getChannel();
        }
        catch (FileNotFoundException fnfe) {
            if (fullPath.isDirectory()) {
                throw Py.IOError(Errno.EISDIR, name);
            }
            if (this.writing && !fullPath.canWrite() || fnfe.getMessage().endsWith("(Permission denied)")) {
                throw Py.IOError(Errno.EACCES, name);
            }
            throw Py.IOError(Errno.ENOENT, name);
        }
        this.initPosition();
    }

    public FileIO(FileChannel fileChannel, String mode) {
        this.parseMode(mode);
        this.fileChannel = fileChannel;
        this.initPosition();
    }

    private void parseMode(String mode) {
        boolean rwa = false;
        block6: for (int i = 0; i < mode.length(); ++i) {
            switch (mode.charAt(i)) {
                case 'r': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.reading = true;
                    continue block6;
                }
                case 'w': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.writing = true;
                    continue block6;
                }
                case 'a': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.writing = true;
                    this.appending = true;
                    continue block6;
                }
                case '+': {
                    if (this.plus || !rwa) {
                        this.badMode();
                    }
                    this.plus = true;
                    this.writing = true;
                    continue block6;
                }
                default: {
                    throw Py.ValueError("invalid mode: '" + mode + "'");
                }
            }
        }
        if (!rwa) {
            this.badMode();
        }
    }

    private void badMode() {
        throw Py.ValueError("Must have exactly one of read/write/append mode");
    }

    private void initPosition() {
        if (this.appending) {
            this.seek(0L, 2);
        } else if (this.writing && !this.reading) {
            try {
                this.fileChannel.truncate(0L);
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equals("Invalid argument")) {
                    return;
                }
                throw Py.IOError(ioe);
            }
        }
    }

    public boolean isatty() {
        this.checkClosed();
        if (this.file == null) {
            return false;
        }
        try {
            return imp.load("os").invoke("isatty", Py.java2py(this.file.getFD())).__nonzero__();
        }
        catch (IOException e) {
            return false;
        }
    }

    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.fileChannel.read(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long readinto(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.fileChannel.read(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public ByteBuffer readall() {
        long toRead;
        this.checkClosed();
        this.checkReadable();
        try {
            toRead = Math.max(0L, this.fileChannel.size() - this.fileChannel.position());
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        if (toRead > Integer.MAX_VALUE) {
            throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
        }
        ByteBuffer all = ByteBuffer.allocate((int)toRead);
        this.readinto(all);
        all.flip();
        return all;
    }

    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.fileChannel.write(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long write(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.fileChannel.write(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long seek(long pos, int whence) {
        this.checkClosed();
        try {
            switch (whence) {
                case 0: {
                    break;
                }
                case 1: {
                    pos += this.fileChannel.position();
                    break;
                }
                case 2: {
                    pos += this.fileChannel.size();
                    break;
                }
                default: {
                    throw Py.IOError(Errno.EINVAL);
                }
            }
            this.fileChannel.position(pos);
            return pos;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long tell() {
        this.checkClosed();
        try {
            return this.fileChannel.position();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long truncate(long size) {
        this.checkClosed();
        this.checkWritable();
        try {
            long oldPosition = this.fileChannel.position();
            this.fileChannel.truncate(size);
            this.fileChannel.position(oldPosition);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        return size;
    }

    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        super.close();
    }

    public OutputStream asOutputStream() {
        return this.writing ? Channels.newOutputStream(this.fileChannel) : super.asOutputStream();
    }

    public InputStream asInputStream() {
        return this.readable() ? Channels.newInputStream(this.fileChannel) : super.asInputStream();
    }

    public boolean readable() {
        return this.reading || this.plus;
    }

    public boolean writable() {
        return this.writing;
    }

    public Channel getChannel() {
        return this.fileChannel;
    }
}

