% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_radii.R
\name{correct_radii}
\alias{correct_radii}
\title{Correct Radii}
\usage{
correct_radii(cylinder, twig_radius, broken_branch = TRUE)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{twig_radius}{Twig radius in millimeters}

\item{broken_branch}{Enable or disable the broken branch filter. Defaults to enabled (TRUE).}
}
\value{
Returns a data frame
}
\description{
Corrects cylinder radii
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)
cylinder <- correct_radii(cylinder, twig_radius = 4.23)
str(cylinder)

}
