% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune_qsm.R
\name{prune_qsm}
\alias{prune_qsm}
\title{Prune QSM}
\usage{
prune_qsm(
  cylinder,
  cylinder_ids = NULL,
  branch_ids = NULL,
  segment_ids = NULL,
  height_m = NULL,
  diameter_cm = NULL,
  invert = FALSE,
  index = FALSE
)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{cylinder_ids}{A single or vector of cylinder ids. Everything connected above the cylinder is pruned.}

\item{branch_ids}{A single or vector of branch ids. Everything connected to the branch is pruned.}

\item{segment_ids}{A single or vector of segment ids. Everything connected above the segment is pruned.}

\item{height_m}{Height class in meters below which all cylinders are pruned. Valid inputs are numeric to one decimal.}

\item{diameter_cm}{Branch diameter class in centimeters below which all cylinders are pruned. Valid inputs are numeric to one decimal.}

\item{invert}{Return the remaining or pruned data. Defaults to TRUE (the remaining data), but can be set to FALSE.}

\item{index}{Returns a column index called \code{pruning} indicating if the cylinder is pruned (1) or un-pruned (0). Defaults to FALSE, but can be set to TRUE.}
}
\value{
a data frame
}
\description{
Efficiently prune a QSM. The user can prune by cylinder, branch,
and segment ids, or by height or diameter classes, individually, or all at
the same time, and return either the pruned data, the remaining data, or a
binary index of which cylinders are pruned.
}
\examples{

## Load QSM
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)

## Pruning Index
prune1 <- prune_qsm(cylinder, height_m = 2, index = TRUE)
plot_qsm(prune1, color = pruning, palette = "blue2red")

## Remaining
prune2 <- prune_qsm(cylinder, height_m = 2, invert = FALSE)
plot_qsm(prune2)

## Pruned
prune3 <- prune_qsm(cylinder, height_m = 2, invert = TRUE)
plot_qsm(prune3)

}
