% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{crs}
\alias{crs}
\title{Collaborative Filtering}
\usage{
crs(dataset, id, prod, pred, rate, data_filter = "", envir = parent.frame())
}
\arguments{
\item{dataset}{Dataset}

\item{id}{String with name of the variable containing user ids}

\item{prod}{String with name of the variable with product ids}

\item{pred}{Products to predict for}

\item{rate}{String with name of the variable with product ratings}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "training == 1")}

\item{envir}{Environment to extract data from}
}
\value{
A data.frame with the original data and a new column with predicted ratings
}
\description{
Collaborative Filtering
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/crs.html} for an example in Radiant
}
\examples{
crs(ratings, id = "Users", prod = "Movies", pred = c("M6", "M7", "M8", "M9", "M10"),
    rate = "Ratings", data_filter = "training == 1") \%>\% str()

}
\seealso{
\code{\link{summary.crs}} to summarize results

\code{\link{plot.crs}} to plot results if the actual ratings are available
}
