% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl.R
\name{summary.mnl}
\alias{summary.mnl}
\title{Summary method for the mnl function}
\usage{
\method{summary}{mnl}(object, sum_check = "", conf_lev = 0.95, test_var = "", dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{mnl}}}

\item{sum_check}{Optional output. "confint" to show coefficient confidence interval estimates. "rrr" to show relative risk ratios (RRRs) and confidence interval estimates.}

\item{conf_lev}{Confidence level to use for coefficient and RRRs confidence intervals (.95 is the default)}

\item{test_var}{Variables to evaluate in model comparison (i.e., a competing models Chi-squared test)}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for the mnl function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/mnl.html} for an example in Radiant
}
\examples{
result <- mnl(
  ketchup,
  rvar = "choice",
  evar = c("price.heinz28", "price.heinz32", "price.heinz41", "price.hunts32"),
  lev = "heinz28"
)
summary(result)

}
\seealso{
\code{\link{mnl}} to generate the results

\code{\link{plot.mnl}} to plot the results

\code{\link{predict.mnl}} to generate predictions

\code{\link{plot.model.predict}} to plot prediction output
}
