% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_clus.R
\name{hier_clus}
\alias{hier_clus}
\title{Hierarchical cluster analysis}
\usage{
hier_clus(dataset, vars, distance = "sq.euclidian", method = "ward.D",
  max_cases = 1000, data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{vars}{Vector of variables to include in the analysis}

\item{distance}{Distance}

\item{method}{Method}

\item{max_cases}{Maximum number of cases allowed (default is 1000)}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables used in hier_clus as an object of class hier_clus
}
\description{
Hierarchical cluster analysis
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/hier_clus.html} for an example in Radiant
}
\examples{
result <- hier_clus("shopping", vars = "v1:v6")

}
\seealso{
\code{\link{summary.hier_clus}} to summarize results

\code{\link{plot.hier_clus}} to plot results
}

