% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/single_prop.R
\name{single_prop}
\alias{single_prop}
\title{Compare a sample proportion to a population proportion}
\usage{
single_prop(dataset, sp_var, data_filter = "", sp_levels = "",
  sp_comp_value = 0.5, sp_alternative = "two.sided", sp_sig_level = 0.95)
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{sp_var}{The variable selected for the proportion comparison}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{sp_levels}{The factor level selected for the proportion comparison}

\item{sp_comp_value}{Population value to compare to the sample proportion}

\item{sp_alternative}{The alternative hypothesis ("two.sided", "greater", or "less")}

\item{sp_sig_level}{Span of the confidence interval}
}
\value{
A list of variables used in single_prop as an object of class single_prop
}
\description{
Compare a sample proportion to a population proportion
}
\details{
See \url{http://mostly-harmless.github.io/radiant/quant/single_prop.html} for an example in Radiant
}
\examples{
result <- single_prop("diamonds","clarity", sp_levels = "IF", sp_comp_value = 0.05)
}
\seealso{
\code{\link{summary.single_prop}} to summarize the results

\code{\link{plot.single_prop}} to plot the results
}

