% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/single_mean.R
\name{single_mean}
\alias{single_mean}
\title{Compare a sample mean to a population mean}
\usage{
single_mean(dataset, sm_var, data_filter = "", sm_comp_value = 0,
  sm_alternative = "two.sided", sm_sig_level = 0.95)
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{sm_var}{The variable selected for the mean comparison}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{sm_comp_value}{Population value to compare to the sample mean}

\item{sm_alternative}{The alternative hypothesis ("two.sided", "greater", or "less")}

\item{sm_sig_level}{Span for the confidence interval}
}
\value{
A list of variables defined in single_mean as an object of class single_mean
}
\description{
Compare a sample mean to a population mean
}
\details{
See \url{http://vnijs.github.io/radiant/quant/single_mean.html} for an example in Radiant
}
\examples{
single_mean("diamonds","price")
}
\seealso{
\code{\link{summary.single_mean}} to summarize results

\code{\link{plot.single_mean}} to plot results
}

