% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlation}
\alias{correlation}
\title{Calculate correlations for two or more variables}
\usage{
correlation(dataset, cor_var, data_filter = "", cor_type = "pearson")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{cor_var}{Variables to include in the analysis}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{cor_type}{Type of correlations to calculate. Options are "pearson", "spearman", and "kendall". "pearson" is the default}
}
\value{
A list with all variables defined in the function as an object of class compare_means
}
\description{
Calculate correlations for two or more variables
}
\details{
See \url{http://vnijs.github.io/radiant/quant/correlation.html} for an example in Radiant
}
\examples{
result <- correlation("diamonds",c("price","carat","clarity"))
result <- correlation("diamonds",c("price:table"))
}
\seealso{
\code{\link{summary.correlation}} to summarize results

\code{\link{plot.correlation}} to plot results
}

