% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qn.R
\name{fFixQN}
\alias{fFixQN}
\title{quasi-Newton when f is fixed}
\usage{
fFixQN(gnew, qnew, f, tol, method, pubdata)
}
\arguments{
\item{gnew}{Integer which length is the number of SNPs used in calculation.}

\item{qnew}{Initial q used in calculation. A vector. sum(q) must be 1.}

\item{f}{Allele frequencies learned from the reference panels.}

\item{tol}{Tolerance, the default value is 1e-4.}

\item{method}{Choose which algorithm you want to use. EM or BR.}

\item{pubdata}{You can choose a public dataset here, E11, K13, K4, K12b, K7b, World9. You also can use other public
dataset which is not in this package.}
}
\value{
Estimation results of q and the loglikelihood value of each iteration.
}
\description{
quasi-Newton for ancestry analysis when F is fixed
}
\examples{
## res <- tfrdpub(genotype, 4, globe4.alleles, globe4.4.F)
## ances <- fFixQN(res$g, res$q, res$f, tol = 1e-4, method = 'BR', pubdata = 'K4')
}
