% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnp_si_sp_hist.R
\name{mcnp_si_sp_hist}
\alias{mcnp_si_sp_hist}
\title{energy distribution histogram entries}
\usage{
mcnp_si_sp_hist(emin, bin_prob, my_dir = NULL)
}
\arguments{
\item{emin}{A vector of lower bounding energy. (The highest energy is the higher bound.) If higher bounding energy data is available, convert it to lower bound by concatenating e.g. `emin = c(my_low-E, emax_data)`. This vector length must exceed the probability vector by 1.}

\item{bin_prob}{A vector of the bin probabilities. There are n-1 probability values for n values of emin.}

\item{my_dir}{Optional directory. The function will write an output text file, si_sp.txt to the working directory by default.}
}
\value{
A vector of energy bins and probabilities for an energy distribution, formatted as needed for MCNP input. It is designed for copying and pasting into an MCNP input. (The # should be changed to the appropriate distribution number.) The data is saved in the global environment and appended to a file in the user's working directory, si_sp.txt. Two plots of the data are provided to the plot window,  one with two linear axes and one with two log axes.
}
\description{
Make MCNP histogram probabilities for energy bins.
}
\details{
Data may be identified by named vector, e.g. my_emin_data, or by column of a data frame, e.g. photons_cs137_hist[1] (which is in emax format) and photons_cs137_hist[2] (bin_prob).
}
\examples{
\dontrun{
mcnp_si_sp_hist(
  emin = c(0, photons_cs137_hist$E_MeV),
  bin_prob = photons_cs137_hist$prob
)
}
}
\seealso{
[mcnp_si_sp_hist_scan()] for copy and paste in data

[mcnp_si_sp_RD()] for data from `RadData`

Other mcnp tools: 
\code{\link{mcnp_cone_angle}()},
\code{\link{mcnp_est_nps}()},
\code{\link{mcnp_matrix_rotations}()},
\code{\link{mcnp_plot_out_spec}()},
\code{\link{mcnp_scan2plot}()},
\code{\link{mcnp_scan2spec}()},
\code{\link{mcnp_scan_save}()},
\code{\link{mcnp_si_sp_RD}()},
\code{\link{mcnp_si_sp_hist_scan}()}
}
\concept{mcnp tools}
