% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown-document.R
\name{MarkdownDocument}
\alias{MarkdownDocument}
\title{Markdown documents}
\arguments{
\item{text}{[string] Markdown text.}

\item{origin}{[string] Optional source path or URL. Defaults to the
\code{"origin"} attribute of \code{text}, if present, otherwise \code{NULL}.}
}
\value{
An S7 object that inherits from \code{MarkdownDocument}, which is a length
1 string of markdown text with an \verb{@origin} property.
}
\description{
\code{MarkdownDocument} represents a complete Markdown document stored as a single
character string. The constructor normalizes \code{text} by collapsing lines and
ensuring UTF-8 encoding, so downstream code can rely on a consistent format.

\code{\link[=read_as_markdown]{read_as_markdown()}} is the recommended way to create a \code{MarkdownDocument}.
The constructor itself is exported only so advanced users can construct one by
other means when needed.
}
\examples{
md <- MarkdownDocument(
  "# Title\n\nSome text.",
  origin = "example.md"
)
md
}
