/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.conceptdrift;

import com.google.common.util.concurrent.AtomicDouble;
import eu.amidst.core.conceptdrift.FadingLearner;
import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.exponentialfamily.EF_BayesianNetwork;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.learning.parametric.ParallelMaximumLikelihood;

public class MaximumLikelihoodFading
extends ParallelMaximumLikelihood
implements FadingLearner {
    double fadingFactor;

    public double getFadingFactor() {
        return this.fadingFactor;
    }

    @Override
    public void setFadingFactor(double fadingFactor) {
        this.fadingFactor = fadingFactor;
    }

    @Override
    public double updateModel(DataOnMemory<DataInstance> batch) {
        SufficientStatistics batchSS = batch.stream().map(this.efBayesianNetwork::getSufficientStatistics).reduce(SufficientStatistics::sumVectorNonStateless).get();
        this.sumSS.multiplyBy(this.fadingFactor);
        this.sumSS.sum(batchSS);
        this.dataInstanceCount.set(this.dataInstanceCount.get() * this.fadingFactor + (double)batch.getNumberOfDataInstances());
        return Double.NaN;
    }

    @Override
    public void runLearning() {
        this.efBayesianNetwork = new EF_BayesianNetwork(this.dag);
        this.dataInstanceCount = new AtomicDouble(0.0);
        this.sumSS = this.efBayesianNetwork.createZeroSufficientStatistics();
        for (DataOnMemory batch : this.dataStream.iterableOverBatches(this.windowsSize)) {
            SufficientStatistics batchSS = batch.stream().map(this.efBayesianNetwork::getSufficientStatistics).reduce(SufficientStatistics::sumVectorNonStateless).get();
            this.sumSS.multiplyBy(this.fadingFactor);
            this.sumSS.sum(batchSS);
            this.dataInstanceCount.set(this.dataInstanceCount.get() * this.fadingFactor + (double)this.windowsSize);
        }
    }

    @Override
    public void setParallelMode(boolean parallelMode) {
        throw new UnsupportedOperationException("Non Parallel Mode Supported.");
    }
}

