/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.Normal;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_NormalGivenJointNormalGamma;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.ParameterVariables;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.ArrayVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class EF_Normal
extends EF_UnivariateDistribution {
    public static final int EXPECTED_MEAN = 0;
    public static final int EXPECTED_SQUARE = 1;
    public static final int INDEX_MEAN = 0;
    public static final int INDEX_PRECISION = 1;
    private static final double LIMIT = 100000.0;

    public EF_Normal(Variable var1) {
        if (!var1.isNormal() && !var1.isParameterVariable()) {
            throw new UnsupportedOperationException("Creating a Gaussian EF distribution for a non-gaussian variable.");
        }
        this.parents = new ArrayList();
        this.var = var1;
        this.naturalParameters = new ArrayVectorParameter(2);
        this.momentParameters = new ArrayVector(2);
        this.momentParameters.set(0, 0.0);
        this.momentParameters.set(1, 1.0);
        this.setMomentParameters(this.momentParameters);
    }

    public double getMean() {
        return this.naturalParameters.get(0);
    }

    public double getPrecision() {
        return this.naturalParameters.get(1);
    }

    public void setNaturalWithMeanPrecision(double mean, double precision) {
        this.naturalParameters.set(0, mean);
        this.naturalParameters.set(1, precision);
    }

    @Override
    public void fixNumericalInstability() {
    }

    @Override
    public double computeLogBaseMeasure(double val) {
        return -0.5 * Math.log(Math.PI * 2);
    }

    @Override
    public double computeLogNormalizer() {
        return -0.5 * Math.log(this.getPrecision()) + 0.5 * this.getPrecision() * Math.pow(this.getMean(), 2.0);
    }

    @Override
    public Vector createZeroVector() {
        return new ArrayVector(2);
    }

    @Override
    public NaturalParameters createZeroNaturalParameters() {
        return new ArrayVectorParameter(2);
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        SufficientStatistics vector = this.createZeroSufficientStatistics();
        double mean = 0.0;
        double meansquare = 0.1;
        vector.set(0, mean);
        vector.set(1, meansquare);
        return vector;
    }

    @Override
    public SufficientStatistics getSufficientStatistics(double val) {
        SufficientStatistics vec = this.createZeroSufficientStatistics();
        vec.set(0, val);
        vec.set(1, val * val);
        return vec;
    }

    @Override
    public Vector getExpectedParameters() {
        ArrayVectorParameter vec = new ArrayVectorParameter(1);
        vec.set(0, this.momentParameters.get(0));
        return vec;
    }

    @Override
    public double computeLogProbabilityOf(double val) {
        throw new UnsupportedOperationException("No implemented yet");
    }

    @Override
    public EF_UnivariateDistribution deepCopy(Variable var) {
        EF_Normal copy = new EF_Normal(var);
        copy.getNaturalParameters().copy(this.getNaturalParameters());
        copy.getMomentParameters().copy(this.getMomentParameters());
        return copy;
    }

    @Override
    public EF_UnivariateDistribution deepCopy() {
        return this.deepCopy(this.var);
    }

    @Override
    public EF_UnivariateDistribution randomInitialization(Random random) {
        double mean = random.nextGaussian() * 10.0;
        double var = random.nextDouble() * 10.0 + 1.0;
        this.setNaturalWithMeanPrecision(mean, 1.0 / var);
        this.fixNumericalInstability();
        this.updateMomentFromNaturalParameters();
        return this;
    }

    public Normal toUnivariateDistribution() {
        Normal normal = new Normal(this.getVariable());
        normal.setMean(this.getMean());
        normal.setVariance(1.0 / this.getPrecision());
        return normal;
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        double m0 = this.momentParameters.get(0);
        double m1 = this.momentParameters.get(1);
        double variance = m1 - m0 * m0;
        if (variance < 0.0) {
            throw new IllegalStateException("Negative variance value");
        }
        if (variance < 1.0E-5) {
            variance = 1.0E-5;
        }
        this.setNaturalWithMeanPrecision(m0, 1.0 / variance);
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        this.momentParameters.set(0, this.getMean());
        double expt_square = 1.0 / this.getPrecision() + Math.pow(this.getMean(), 2.0);
        if (expt_square <= 0.0) {
            throw new IllegalStateException("Zero or Negative expected square value");
        }
        this.momentParameters.set(1, expt_square);
    }

    @Override
    public SufficientStatistics getSufficientStatistics(Assignment data) {
        return this.getSufficientStatistics(data.getValue(this.var));
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return 2;
    }

    @Override
    public double computeLogBaseMeasure(Assignment dataInstance) {
        return this.computeLogBaseMeasure(dataInstance.getValue(this.var));
    }

    @Override
    public List<EF_ConditionalDistribution> toExtendedLearningDistribution(ParameterVariables variables, String nameSuffix) {
        ArrayList<EF_ConditionalDistribution> conditionalDistributions = new ArrayList<EF_ConditionalDistribution>();
        Variable varNormalGamma = variables.newNormalGamma(this.var.getName() + "_NormalGamma_Parameter_" + nameSuffix + "_" + variables.getNumberOfVars());
        conditionalDistributions.add((EF_ConditionalDistribution)((DistributionType)varNormalGamma.getDistributionType()).newEFUnivariateDistribution());
        EF_NormalGivenJointNormalGamma dist = new EF_NormalGivenJointNormalGamma(this.var, varNormalGamma);
        conditionalDistributions.add(dist);
        return conditionalDistributions;
    }

    @Override
    public NaturalParameters getExpectedNaturalFromParents(Map<Variable, MomentParameters> momentParents) {
        ArrayVectorParameter out = new ArrayVectorParameter(2);
        out.copy(this.getNaturalParameters());
        return out;
    }

    @Override
    public double kl(NaturalParameters naturalParameters, double logNormalizer) {
        double meanQ = naturalParameters.get(0);
        double precisionQ = naturalParameters.get(1);
        double kl = 0.5 * Math.log(this.getPrecision()) - 0.5 * Math.log(precisionQ) + 0.5 * precisionQ / this.getPrecision() + 0.5 * precisionQ * Math.pow(this.getMean() - meanQ, 2.0) - 0.5;
        if (Double.isNaN(kl)) {
            throw new IllegalStateException("NaN KL");
        }
        if (kl < 0.0) {
            kl = 0.0;
        }
        return kl;
    }

    public static class ArrayVectorParameter
    implements MomentParameters,
    NaturalParameters,
    SufficientStatistics,
    Serializable {
        private static final long serialVersionUID = -3436599636425587512L;
        private double[] array;

        public ArrayVectorParameter(int size) {
            this.array = new double[size];
        }

        public ArrayVectorParameter(double[] vec) {
            this.array = vec;
        }

        public double[] toArray() {
            return this.array;
        }

        public void copy(ArrayVectorParameter vector) {
            if (vector.size() != vector.size()) {
                throw new IllegalArgumentException("Vectors with different sizes");
            }
            System.arraycopy(vector.toArray(), 0, this.array, 0, vector.toArray().length);
        }

        @Override
        public double get(int i) {
            return this.array[i];
        }

        @Override
        public void set(int i, double val) {
            this.array[i] = val;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public void sum(Vector vector) {
            if (this.size() != vector.size()) {
                throw new IllegalArgumentException("Vectors has different sizes");
            }
            double mean1 = this.array[0];
            double precision1 = this.array[1];
            double mean2 = vector.get(0);
            double precision2 = vector.get(1);
            if (precision1 + precision2 != 0.0) {
                double newmean = precision1 / (precision1 + precision2) * mean1 + precision2 / (precision1 + precision2) * mean2;
                double newprecision = precision1 + precision2;
                this.array[0] = newmean;
                this.array[1] = newprecision;
            }
        }

        @Override
        public void substract(Vector vector) {
            if (this.size() != vector.size()) {
                throw new IllegalArgumentException("Vectors has different sizes");
            }
            double mean1 = this.array[0];
            double precision1 = this.array[1];
            double mean2 = vector.get(0);
            double precision2 = vector.get(1);
            if (precision1 - precision2 != 0.0) {
                double newmean = precision1 / (precision1 - precision2) * mean1 - precision2 / (precision1 - precision2) * mean2;
                double newprecision = precision1 - precision2;
                this.array[0] = newmean;
                this.array[1] = newprecision;
            } else {
                this.array[0] = 0.0;
                this.array[1] = 0.0;
            }
        }

        @Override
        public void copy(Vector vector) {
            if (this.size() != vector.size()) {
                throw new IllegalArgumentException("Vectors has different sizes");
            }
            if (!vector.getClass().isAssignableFrom(ArrayVectorParameter.class)) {
                throw new IllegalArgumentException("Not compatible class");
            }
            this.copy((ArrayVectorParameter)vector);
        }

        @Override
        public void divideBy(double val) {
            throw new UnsupportedOperationException("");
        }

        @Override
        public void multiplyBy(double val) {
            this.array[1] = this.array[1] * val;
        }

        @Override
        public double dotProduct(Vector vector) {
            double mean1 = this.array[0];
            double precision1 = this.array[1];
            return precision1 * mean1 * vector.get(0) - 0.5 * precision1 * vector.get(1);
        }
    }
}

