/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.models;

import eu.amidst.core.models.ParentSet;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.Variables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DAG
implements Serializable {
    private static final long serialVersionUID = 2889423026182605212L;
    private Variables variables;
    private List<ParentSet> parents;
    private String name = "DAG";

    public DAG(Variables variables) {
        this.variables = variables;
        this.parents = new ArrayList<ParentSet>(variables.getNumberOfVars());
        for (Variable var : variables) {
            this.parents.add(var.getVarID(), new ParentSetImpl(var));
        }
        this.variables.block();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getNumberOfLinks() {
        return this.parents.stream().mapToInt(p -> p.getNumberOfParents()).sum();
    }

    public Variables getVariables() {
        return this.variables;
    }

    public ParentSet getParentSet(Variable var) {
        return this.parents.get(var.getVarID());
    }

    public List<ParentSet> getParentSets() {
        return this.parents;
    }

    public boolean containCycles() {
        boolean[] bDone = new boolean[this.variables.getNumberOfVars()];
        for (Variable var : this.variables) {
            bDone[var.getVarID()] = false;
        }
        boolean bFound = false;
        for (Variable variable2 : this.variables) {
            if (bDone[variable2.getVarID()]) continue;
            boolean bHasNoParents = true;
            for (Variable parent : this.getParentSet(variable2)) {
                if (bDone[parent.getVarID()]) continue;
                bHasNoParents = false;
            }
            if (!bHasNoParents) continue;
            bDone[variable2.getVarID()] = true;
            bFound = true;
            break;
        }
        return !bFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DAG dag = (DAG)o;
        if (this.variables.getNumberOfVars() != dag.variables.getNumberOfVars()) {
            return false;
        }
        boolean eqs = true;
        for (Variable var : this.getVariables()) {
            if (this.getParentSet(var).equals(dag.getParentSet(dag.getVariables().getVariableByName(var.getName())))) continue;
            eqs = false;
            break;
        }
        return eqs;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("DAG\n");
        for (Variable var : this.getVariables()) {
            str.append(var.getName() + " has " + this.getParentSet(var).getNumberOfParents() + " parent(s): " + this.getParentSet(var).toString() + "\n");
        }
        return str.toString();
    }

    private static final class ParentSetImpl
    implements ParentSet,
    Serializable {
        private static final long serialVersionUID = 3580889238865345208L;
        private Variable mainVar;
        private List<Variable> vars;

        private ParentSetImpl(Variable mainVar1) {
            this.mainVar = mainVar1;
            this.vars = new ArrayList<Variable>();
        }

        @Override
        public Variable getMainVar() {
            return this.mainVar;
        }

        @Override
        public void addParent(Variable var) {
            if (!((DistributionType)this.mainVar.getDistributionType()).isParentCompatible(var)) {
                throw new IllegalArgumentException("Adding a parent var " + var.getName() + " of type " + var.getDistributionTypeEnum().toString() + " which is not compatible " + "with children variable " + this.getMainVar().getName() + " of type " + this.mainVar.getDistributionTypeEnum().toString());
            }
            if (this.contains(var)) {
                throw new IllegalArgumentException("Trying to add a duplicated parent");
            }
            this.vars.add(var);
        }

        @Override
        public void removeParent(Variable var) {
            this.vars.remove(var);
        }

        @Override
        public List<Variable> getParents() {
            return this.vars;
        }

        @Override
        public int getNumberOfParents() {
            return this.vars.size();
        }

        @Override
        public String toString() {
            int numParents = this.getNumberOfParents();
            StringBuilder str = new StringBuilder();
            str.append("{");
            for (int i = 0; i < numParents; ++i) {
                Variable parent = this.getParents().get(i);
                str.append(parent.getName());
                if (i >= numParents - 1) continue;
                str.append(", ");
            }
            str.append("}");
            return str.toString();
        }

        @Override
        public void blockParents() {
        }

        @Override
        public boolean contains(Variable var) {
            return this.vars.contains(var);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParentSet parentset = (ParentSet)o;
            if (this.getNumberOfParents() != parentset.getNumberOfParents()) {
                return false;
            }
            int i = 0;
            boolean eqs = true;
            while (i < this.getNumberOfParents() && eqs) {
                if (this.getParents().get(i).equals(parentset.getParents().get(i))) {
                    ++i;
                    continue;
                }
                eqs = false;
            }
            return eqs;
        }
    }
}

