/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.utils.AmidstOptionsHandler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class OptionParser {
    private static final String subOptionSeparator = "--";
    private static HashMap<String, HashMap<String, String>> allOptions;
    private static String confFileNameDefault;
    private static String confFileName;
    private static String[] commandLineOptions;
    private static String optionString;

    public static void setConfFileName(String fileName) {
        confFileName = fileName;
    }

    public static void setArgsOptions(Class className, String[] args) {
        OptionParser.setArgsOptions(className.getName(), args);
    }

    public static void setArgsOptions(String classNameID, String[] args) {
        commandLineOptions = new String[args.length + 1];
        OptionParser.commandLineOptions[0] = subOptionSeparator + classNameID;
        int offset = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("--help")) {
                String options;
                if (args.length == 1) {
                    options = OptionParser.getListOptions(classNameID);
                    options = options.replace("\\", "\n");
                    System.out.println(options);
                } else if (args[++i].equalsIgnoreCase("-r")) {
                    options = OptionParser.getListOptionsRecursively(classNameID);
                    options = options.replace("\\", "\n");
                    System.out.println(options);
                }
                System.exit(0);
            }
            if (args[i].equalsIgnoreCase("-confFile")) {
                OptionParser.setConfFileName(args[i++]);
                offset = 2;
                continue;
            }
            OptionParser.commandLineOptions[i + 1 - offset] = args[i];
        }
        if (offset == 2) {
            commandLineOptions = new String[commandLineOptions.length - 2];
            System.arraycopy(commandLineOptions, 0, commandLineOptions, 0, commandLineOptions.length - 2);
        }
    }

    public static String parse(String classNameID, String defaultOptions, String optionName) {
        if (allOptions == null) {
            OptionParser.loadFileOptions();
            OptionParser.loadCommandLineOptions(classNameID);
            OptionParser.loadDefaultOptions(defaultOptions);
            optionString = allOptions.toString();
        } else if (allOptions.get(classNameID) == null) {
            OptionParser.loadDefaultOptions(defaultOptions);
        } else if (allOptions.get(classNameID).get(optionName) == null) {
            OptionParser.loadDefaultOptions(defaultOptions);
        }
        return allOptions.get(classNameID).get(optionName);
    }

    public static void loadFileOptions() {
        allOptions = new HashMap();
        if (confFileName.isEmpty()) {
            Path pathFile = Paths.get(confFileNameDefault, new String[0]);
            try {
                Files.lines(pathFile).filter(line -> !line.startsWith("%")).forEach(line -> OptionParser.parseLine(line));
            }
            catch (IOException iOException) {}
        } else {
            Path pathFile = Paths.get(confFileName, new String[0]);
            try {
                Files.lines(pathFile).filter(line -> !line.startsWith("%")).forEach(line -> OptionParser.parseLine(line));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private static void parseLine(String line) {
        String[] splitLine = line.split("\\s+|\\s*,\\s*|\\s*=\\s*");
        HashMap<String, String> local = new HashMap<String, String>();
        if (allOptions.get(splitLine[0]) == null) {
            for (int i = 1; i < splitLine.length - 1; ++i) {
                local.put(splitLine[i].trim(), splitLine[++i].trim());
            }
            if (!local.isEmpty()) {
                allOptions.put(splitLine[0].trim(), local);
            }
        } else {
            for (int i = 1; i < splitLine.length - 1; ++i) {
                allOptions.get(splitLine[0]).put(splitLine[i].trim(), splitLine[++i].trim());
            }
        }
    }

    public static void loadCommandLineOptions(String classNameID) {
        String className = classNameID;
        HashMap<String, String> local = new HashMap<String, String>();
        for (int i = 0; i < commandLineOptions.length; ++i) {
            if (commandLineOptions[i].startsWith(subOptionSeparator)) {
                if (!local.isEmpty()) {
                    allOptions.put(className, local);
                }
                className = commandLineOptions[i].replace(subOptionSeparator, "");
                local = new HashMap();
                continue;
            }
            if (allOptions.get(className) == null) {
                if (i + 1 < commandLineOptions.length && !commandLineOptions[i + 1].trim().startsWith("-")) {
                    local.put(commandLineOptions[i].trim(), commandLineOptions[++i].trim());
                    continue;
                }
                local.put(commandLineOptions[i].trim(), "true");
                continue;
            }
            if (i + 1 < commandLineOptions.length && !commandLineOptions[i + 1].trim().startsWith("-")) {
                allOptions.get(className).put(commandLineOptions[i].trim(), commandLineOptions[++i].trim());
                continue;
            }
            allOptions.get(className).put(commandLineOptions[i].trim(), "true");
        }
        if (!local.isEmpty()) {
            allOptions.put(className, local);
        }
    }

    public static void loadDefaultOptions(String defaultOptions) {
        String[] options = defaultOptions.split(",\\\\|\\s*,\\s*|\\\\");
        String className = options[0];
        HashMap<String, String> local = new HashMap<String, String>();
        for (int i = 1; i < options.length; ++i) {
            if (options[i].equals("\t")) {
                allOptions.putIfAbsent(className, local);
                className = options[++i].trim();
                local = new HashMap();
            } else if (allOptions.get(className) == null) {
                local.put(options[i].trim(), options[++i].trim());
            } else {
                allOptions.get(className).putIfAbsent(options[i].trim(), options[++i].trim());
            }
            ++i;
        }
        if (!local.isEmpty()) {
            allOptions.put(className, local);
        }
    }

    public static String getListOptions(String classNameID) {
        try {
            return ((AmidstOptionsHandler)Class.forName(classNameID).newInstance()).listOptions();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The class " + classNameID + " does not exist");
        }
    }

    public static String getListOptionsRecursively(String classNameID) {
        try {
            return ((AmidstOptionsHandler)Class.forName(classNameID).newInstance()).listOptionsRecursively();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        confFileNameDefault = "configurationFiles/conf.txt";
        confFileName = "";
        commandLineOptions = new String[0];
        optionString = "";
    }
}

