% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebcPar.R
\name{ebcPar}
\alias{ebcPar}
\title{Representing Efron's Biased Coin Design}
\usage{
ebcPar(N, p, groups = LETTERS[1:2])
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{p}{success probability of the biased coin (e.g. in Efron's Biased Coin
Design).}

\item{groups}{character vector of labels for the different treatments.}
}
\value{
\code{S4} object of the class \code{ebcPar}.
}
\description{
Represents the randomization procedure Efron's Biased Coin Design.
}
\details{
Flip a biased coin with probability \code{p} in favour of the treatment
which is allocated less frequently. If both treatments have been assigned
equally often a fair coin is tossed.
}
\references{
B. Efron (1971) Forcing a sequential experiment to be balanced. \emph{Biometrika},
\strong{58}, 403-17.
}
\seealso{
Other randomization procedures: \code{\link{abcdPar}},
  \code{\link{bbcdPar}}, \code{\link{bsdPar}},
  \code{\link{chenPar}}, \code{\link{crPar}},
  \code{\link{createParam}}, \code{\link{gbcdPar}},
  \code{\link{hadaPar}}, \code{\link{mpPar}},
  \code{\link{pbrPar}}, \code{\link{rarPar}},
  \code{\link{rpbrPar}}, \code{\link{rtbdPar}},
  \code{\link{tbdPar}}, \code{\link{udPar}}
}

