% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_pkgrefs.R
\name{as_pkgrefs}
\alias{as_pkgrefs}
\alias{as_pkgrefs.default}
\alias{as_pkgrefs.character}
\alias{as_pkgrefs.sessionInfo}
\title{Convert Data Structures into Package References}
\usage{
as_pkgrefs(x, ...)

\method{as_pkgrefs}{default}(x, ...)

\method{as_pkgrefs}{character}(x, bioc_version = NULL, ...)

\method{as_pkgrefs}{sessionInfo}(x, ...)
}
\arguments{
\item{x, }{currently supported data structure(s) are: output from \code{\link[=sessionInfo]{sessionInfo()}}, a character vector of package names}

\item{..., }{not used}

\item{bioc_version}{character. When x is a character vector, version of Bioconductor to search for package names. NULL indicates not
search for Bioconductor.}
}
\value{
a vector of package references
}
\description{
This generic function converts several standard data structures into a vector of package references, which in turn
can be used as the first argument of the function \code{\link[=resolve]{resolve()}}. This function guessimates the possible sources of the
packages. But we strongly recommend manually reviewing the detected packages before using them for \code{\link[=resolve]{resolve()}}.
}
\examples{
as_pkgrefs(sessionInfo())
if (interactive()) {
   require(rang)
   graph <- resolve(as_pkgrefs(sessionInfo()))
   as_pkgrefs(c("rtoot"))
   as_pkgrefs(c("rtoot", "S4Vectors")) ## this gives cran::S4Vectors and is not correct.
   as_pkgrefs(c("rtoot", "S4Vectors"), bioc_version = "3.3") ## This gives bioc::S4Vectors
}
}
