% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synonymMatch.R
\name{synonymMatch}
\alias{synonymMatch}
\title{Match synonyms to accepted names}
\usage{
synonymMatch(
  x,
  db,
  yearCutoff = NULL,
  searchSynonyms = TRUE,
  fuzzyDist = 2,
  advancedSearch = FALSE,
  returnMultiple = FALSE,
  progressBar = TRUE,
  nthreads = 1
)
}
\arguments{
\item{x}{a character vector of Genus_species_subspecies (can be multiple)}

\item{db}{squamates, birds, mammals or amphibians}

\item{yearCutoff}{year for oldest considered synonyms, please treat as experimental.}

\item{searchSynonyms}{if \code{FALSE}, strict and fuzzy matching is applied only
to the list of accepted names}

\item{fuzzyDist}{for fuzzy searching, the maximum string distance allowed
for a match}

\item{advancedSearch}{logical, should advanced searching be used, see
Details.}

\item{returnMultiple}{if \code{FALSE}, \code{NA} is returned if no match
found or if multiple matches found. if \code{TRUE}, then multiple hits are
returned.}

\item{progressBar}{if \code{FALSE}, progress bar will be suppressed.}

\item{nthreads}{number of threads to use for parallelization of the
function.}
}
\value{
a vector of matches, \code{NA} if the species name could not be
	unambiguously matched to a single accepted name. If \code{returnMultiple =
	TRUE}, then \code{NA} is only returned when the taxon name is not matched at
	all in the database.
}
\description{
Performs strict and fuzzy matching to return the accepted species name
}
\details{
The order of the procedure applied here is as follows: \cr
	First Pass: \cr
	\itemize{
	\item Strict matching against accepted names, \cr
	\item fuzzy matching against accepted names, \cr
	\item strict matching against synonyms,\cr 
	\item fuzzy matching against synonyms,\cr
	}
	Second Pass:
	\itemize{
	\item Same as first pass, but ignoring subspecies\cr
	}
	Advanced Search: \cr
	\itemize{
	\item Same as first pass, but with consideration of alternate latin suffixes and 
	all genus/species combinations.
	}

	The squamate database is a local copy of the Reptile Database
	(\url{http://reptile-database.reptarium.cz/}), which will be updated
	periodically. The list of accepted names within this R package are those
	that are listed as such on the website.

	The bird database is the BirdLife Taxonomic Checklist as downloaded
	from \url{http://datazone.birdlife.org/species/taxonomy}.

	The mammal database is Wilson and Reeder's Mammal Species of the World, 3rd
	edition, downloaded from
	\url{http://www.departments.bucknell.edu/biology/resources/msw3/},
	and supplemented with searches of the ITIS database with the 
	\code{taxize} R package.

	The amphibian database is a local copy of the AmphibiaWeb taxonomy
	(\url{https://amphibiaweb.org/taxonomy/index.html}), which will be updated
	periodically.

	To see when these datasets were last updated for this R package, run
	\code{\link{downloadDates}}.
}
\examples{
 
# simple misspelling
synonymMatch('Crotalus_atrix', db = 'squamates')

# synonym
synonymMatch('Pipistrellus_macrotis', db = 'mammals')

# synonym with slight misspelling
synonymMatch('Tangara_pulchirrima', db = 'birds')

# no match, but return multiple
synonymMatch('Masticophis_flagellum', db = 'squamates', returnMultiple = TRUE)

}
\references{
HBW and BirdLife International. 2017. Handbook of the Birds of the World and BirdLife 
International digital checklist of the birds of the world. Version 2 Available at: 
\url{http://datazone.birdlife.org/userfiles/file/Species/Taxonomy/HBW-BirdLife_Checklist_Version_2.zip}

Don E. Wilson and DeeAnn M. Reeder (editors). 2005. Mammal Species of the
World. A Taxonomic and Geographic Reference (3rd ed), Johns Hopkins
University Press, 2, 142 pp.

Uetz P., Hosek, J. (ed.). 2016. The Reptile Database,
\url{http://www.reptile-database.org}.
}
\author{
Pascal Title
}
