% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankFD.R
\name{rankFD}
\alias{rankFD}
\title{Rank-based tests for general factorial designs}
\usage{
rankFD(formula, data, alpha = 0.05, CI.method = c("Logit", "Normal"),
  effect = c("unweighted", "weighted"), hypothesis = c("H0F", "H0p"),
  Factor.Information = FALSE)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side
contains the response variable and the right hand side contains the factor
variables of interest. An interaction term must be specified.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. The default option is \code{NULL}.}

\item{alpha}{A number specifying the significance level; the default is 0.05.}

\item{CI.method}{Either "Logit" or "Normal", specifying the method used for
calculation of the confidence intervals.}

\item{effect}{Should the weighted or unweighted effects be calculated?}

\item{hypothesis}{The null hypothesis to test, either "H0F" or "H0p".}

\item{Factor.Information}{Logical. If TRUE, descriptive statistics for 
the different factor level combinations is printed.}
}
\value{
An \code{rankFD} object containing the following components:
\item{Descriptive}{Some descriptive statistics of the data for all factor
   level combinations. Displayed are the number of individuals per factor
   level combination (size), the relative effect (pd), variance and 100*(1-alpha)\% confidence
   intervals.}
 \item{WTS}{The value of the WTS along with degrees of freedom of the central chi-square distribution and p-value}
 \item{ATS}{The value of the ATS, degrees of freedom of the central F distribution and the corresponding p-value.}
}
\description{
The rankFD() function calculates the Wald-type statistic (WTS) and the ANOVA-type 
statistic (ATS) for general factorial designs.
}
\details{
The package provides the Wald-type as well as the ANOVA-type statistic 
   for rank-based factorial designs, i.e., even for ordinal data.  It is
   implemented for crossed designs and allows
   for an arbitrary number of factor combinations as well as different sample
   sizes.
}
\examples{
data(Coal)
model <- rankFD(Acidity ~ NaOH * Type, data = Coal, CI.method = "Normal",
 effect = "unweighted", hypothesis = "H0F")

data(Muco)
model.oneway <- rankFD(HalfTime ~ Disease, data = Muco, CI.method = "Logit",
 effect = "weighted", hypothesis = "H0p")


}
\references{
Friedrich, S., Konietschke, F., Pauly, M.(2015) GFD - An R-package
for the Analysis of General Factorial Designs. Submitted to Journal of Statistical Software.

Pauly, M., Brunner, E., Konietschke, F.(2015) Asymptotic Permutation Tests in General Factorial Designs. Journal of the Royal Statistical Society - Series B \bold{77}, 461--473.
}

