% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmb.R
\name{dmb}
\alias{dmb}
\title{Mallows-Binomial density function}
\usage{
dmb(Pi, X, p, pi0 = NULL, theta, M, log = FALSE)
}
\arguments{
\item{Pi}{Matrix of partial or complete rankings, one row per ranking.}

\item{X}{Matrix of ratings, one row per judge and one column per object.}

\item{p}{Vector of object qualities.}

\item{pi0}{Vector specifying the consensus (modal probability) ranking (useful to break ties in p).}

\item{theta}{Numeric specifying the Mallows scale parameter.}

\item{M}{Numeric specifying maximum (=worst quality) integer rating.}

\item{log}{Boolean indicating if loglikelihood should be returned.}
}
\value{
(Log) likelihood of rankings under a Mallows-Binomial distribution.
}
\description{
This function calculates the density of observation(s) under a Mallows-Binomial distribution.
}
\examples{
Pi <- matrix(c(1,2,3,4,2,1,NA,NA),byrow=TRUE,nrow=2)
X <- matrix(c(0,1,2,3,1,2,2,5),byrow=TRUE,nrow=2)
dmb(Pi=Pi,X=X,p=c(.1,.2,.5,.9),theta=1.1,M=5,log=TRUE)
dmb(Pi=Pi,X=X,p=c(.1,.2,.5,.9),theta=2,M=5,log=TRUE)
 
}
