% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleExport.R
\name{export}
\alias{export}
\alias{exportUCInput}
\alias{exportUCServer}
\alias{exportUCApp}
\alias{selectListPubkey}
\alias{exportDb}
\title{Shiny modules providing GUI and server logic for Export}
\usage{
exportUCInput(id)

exportUCServer(id, registryName, repoName = registryName, eligible = TRUE)

exportUCApp(registryName = "rapbase")

selectListPubkey(pubkey)

exportDb(registryName, compress = FALSE, session)
}
\arguments{
\item{id}{Character string module ID}

\item{registryName}{Character string registry name key}

\item{repoName}{Character string defining the github repository name of the
registry. Default value is \code{registryName}.}

\item{eligible}{Logical defining if the module should be allowed to work at
full capacity. This might be useful when access to module products should be
restricted. Default is TRUE, \emph{i.e.} no restrictions.}

\item{pubkey}{Character vector with public keys}

\item{compress}{Logical if export data is to be compressed (using gzip).
FALSE by default.}

\item{session}{Shiny session object}
}
\value{
Shiny objects, mostly. Helper functions may return other stuff too.
}
\description{
Functions for registries that wants to implement exporting of registry
databases, \emph{e.g.} for local development purposes. Also includes
relevant helper functions
}
\examples{
## client user interface function
ui <- shiny::fluidPage(
  shiny::sidebarLayout(
    shiny::sidebarPanel(
      exportUCInput("test"),
    ),
    shiny::mainPanel(
      NULL
    )
  )
)

## server function
server <- function(input, output, session) {
  exportUCServer("test", registryName = "rapbase")
}

## run the shiny app in an interactive environment
if (interactive()) {
  shiny::shinyApp(ui, server)
}
}
