% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stagingData.R
\name{stagingDataHelper}
\alias{stagingDataHelper}
\alias{pathStagingData}
\alias{dbStagingData}
\alias{dbStagingPrereq}
\alias{dbStagingConnection}
\alias{dbStagingProcess}
\alias{wrapStagingData}
\alias{unwrapStagingData}
\title{Data staging helper (internal) functions}
\usage{
pathStagingData(registryName, dir)

wrapStagingData(data, key)

unwrapStagingData(data, key)

dbStagingData(key, drop = FALSE)

dbStagingPrereq(key)

dbStagingConnection(key = NULL, con = NULL, init = FALSE)

dbStagingProcess(key, query, params = list(), statement = FALSE)
}
\arguments{
\item{registryName}{Character string providing the registry name.}

\item{dir}{Character string providing the path to where the staging data
directory resides in case of storage as files. Default value is
\code{Sys.getenv("R_RAP_CONFIG_PATH")}.}

\item{data}{A data object that is to be added to or collected from staging.}

\item{key}{Character string with key to be used for staging data store
credentials.}

\item{drop}{Logical defining if a database is to be deleted. FALSE by
default.}

\item{con}{A database connection object.}

\item{init}{Logical defining if the function call will perform an initial
set-up of a database. Default value is FALSE}

\item{query}{Character string providing a database query.}

\item{params}{List of values to be provided in a parameterized query.}

\item{statement}{Logical defining if a query is a statement or not. Default
value is FALSE.}
}
\value{
\itemize{
  \item \code{pathStagingData()} returns a character string with the path to
    the staging directory of \code{registryName}. If its parent directory
    (\code{dir}) does not exists an error is returned.
  \item \code{dbStagingData()} creates or drops a staging data database and
    returns a message invisibly.
  \item \code{dbStagingPrereq()} ensures that a database for staging data is
    properly setup and returns a message, invisibly.
  \item \code{dbStagingConnection()} returns an open database connection
    object or, when an open connection object is provided as an argument,
    closes it and returns \code{NULL} invisibly.
  \item \code{dbStagingProcess()} returns the raw result of a database query
    based on the arguments provided.
}
}
\description{
A set of helper functions to aid staging of registry data at Rapporteket.
}
\keyword{internal}
