/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.AttributeAnnotation;
import opennlp.tools.formats.brat.BratAnnotation;
import opennlp.tools.formats.brat.EventAnnotation;
import opennlp.tools.formats.brat.RelationAnnotation;
import opennlp.tools.formats.brat.SpanAnnotation;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class BratAnnotationStream
implements ObjectStream<BratAnnotation> {
    private final AnnotationConfiguration config;
    private final BufferedReader reader;
    private final String id;

    BratAnnotationStream(AnnotationConfiguration config, String id, InputStream in) {
        this.config = config;
        this.id = id;
        this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    @Override
    public BratAnnotation read() throws IOException {
        Span[] tokens;
        String line = this.reader.readLine();
        if (line != null && (tokens = WhitespaceTokenizer.INSTANCE.tokenizePos(line)).length > 2) {
            BratAnnotationParser parser;
            String annId = tokens[0].getCoveredText(line).toString();
            if (annId.length() == 0) {
                throw new InvalidFormatException("annotation id is empty");
            }
            switch (annId.charAt(0)) {
                case 'T': {
                    parser = new SpanAnnotationParser();
                    break;
                }
                case 'R': {
                    parser = new RelationAnnotationParser();
                    break;
                }
                case 'A': {
                    parser = new AttributeAnnotationParser();
                    break;
                }
                case 'E': {
                    parser = new EventAnnotationParser();
                    break;
                }
                default: {
                    return this.read();
                }
            }
            try {
                return parser.parse(tokens, line);
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to parse ann document with id [%s.ann]", this.id), e);
            }
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.reader.reset();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static class AttributeAnnotationParser
    extends BratAnnotationParser {
        private static final int ATTACHED_TO_OFFSET = 2;
        private static final int VALUE_OFFSET = 3;

        AttributeAnnotationParser() {
        }

        @Override
        BratAnnotation parse(Span[] values, CharSequence line) throws IOException {
            if (values.length == 3 || values.length == 4) {
                String value = null;
                if (values.length == 4) {
                    value = values[3].getCoveredText(line).toString();
                }
                return new AttributeAnnotation(values[0].getCoveredText(line).toString(), values[1].getCoveredText(line).toString(), values[2].getCoveredText(line).toString(), value);
            }
            throw new InvalidFormatException("Line must have 3 or 4 fields");
        }
    }

    static class EventAnnotationParser
    extends BratAnnotationParser {
        EventAnnotationParser() {
        }

        @Override
        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            String[] typeParts = tokens[1].getCoveredText(line).toString().split(":");
            if (typeParts.length != 2) {
                throw new InvalidFormatException(String.format("Failed to parse [%s], type part must be in the format type:trigger", line));
            }
            String type = typeParts[0];
            String eventTrigger = typeParts[1];
            HashMap<String, String> arguments = new HashMap<String, String>();
            for (int i = 2; i < tokens.length; ++i) {
                String[] parts = tokens[i].getCoveredText(line).toString().split(":");
                if (parts.length != 2) {
                    throw new InvalidFormatException(String.format("Failed to parse [%s], argument parts must be in form argument:value", line));
                }
                arguments.put(parts[0], parts[1]);
            }
            return new EventAnnotation(tokens[0].getCoveredText(line).toString(), type, eventTrigger, arguments);
        }
    }

    static class RelationAnnotationParser
    extends BratAnnotationParser {
        private static final int ARG1_OFFSET = 2;
        private static final int ARG2_OFFSET = 3;

        RelationAnnotationParser() {
        }

        private String parseArg(String arg) throws InvalidFormatException {
            if (arg.length() > 4) {
                return arg.substring(5).trim();
            }
            throw new InvalidFormatException("Failed to parse argument: " + arg);
        }

        @Override
        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            return new RelationAnnotation(tokens[0].getCoveredText(line).toString(), tokens[1].getCoveredText(line).toString(), this.parseArg(tokens[2].getCoveredText(line).toString()), this.parseArg(tokens[3].getCoveredText(line).toString()));
        }
    }

    static class SpanAnnotationParser
    extends BratAnnotationParser {
        private static final int BEGIN_OFFSET = 2;
        private static final int END_OFFSET = 3;

        SpanAnnotationParser() {
        }

        @Override
        BratAnnotation parse(Span[] values, CharSequence line) throws IOException {
            if (values.length > 4) {
                String type = values[1].getCoveredText(line).toString();
                int endOffset = -1;
                int firstTextTokenIndex = -1;
                for (int i = 3; i < values.length; ++i) {
                    if (values[i].getCoveredText(line).toString().contains(";")) continue;
                    endOffset = this.parseInt(values[i].getCoveredText(line).toString());
                    firstTextTokenIndex = i + 1;
                    break;
                }
                String id = values[0].getCoveredText(line).toString();
                String coveredText = line.subSequence(values[firstTextTokenIndex].getStart(), values[values.length - 1].getEnd()).toString();
                try {
                    return new SpanAnnotation(id, type, new Span(this.parseInt(values[2].getCoveredText(line).toString()), endOffset, type), coveredText);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidFormatException(e);
                }
            }
            throw new InvalidFormatException("Line must have at least 5 fields");
        }
    }

    static abstract class BratAnnotationParser {
        static final int ID_OFFSET = 0;
        static final int TYPE_OFFSET = 1;

        BratAnnotationParser() {
        }

        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            return null;
        }

        protected int parseInt(String intString) throws InvalidFormatException {
            try {
                return Integer.parseInt(intString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException(e);
            }
        }
    }
}

