% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DemandPoints.R
\name{make.DemandPoints}
\alias{make.DemandPoints}
\title{Generate demand points for RAP}
\usage{
make.DemandPoints(points, n = 100L, quantile = 0.5,
  kernel.method = c("ks", "hypervolume")[1], ...)
}
\arguments{
\item{points}{\code{SpatialPointsDataFrame} or \code{SpatialPoints} with species presence records.}

\item{n}{\code{integer} number of demand points to use for each attribute space for each species. Defaults to 100L.}

\item{quantile}{\code{numeric} quantile to generate demand points within. If 0 then demand points are generated across the full range of values the \code{points} intersect. Defaults to 0.5.}

\item{kernel.method}{\code{character} name of kernel method to use to generate demand points. Defaults to 'ks'.}

\item{...}{arguments passed to kernel density estimating functions}
}
\value{
\code{DemandPoints} object.
}
\description{
This function generates demand points for RAP using kernels.
}
\details{
The values of the species records in the rasters is extracted. A kernel is fit to the points in the attribute space. 
Volumes are then fit to the points in the attribute space(s). Points are randomly generated inside the volume. Demand points are generated
as random points inside the volume. A kernel is fit to the species records and used to predict the density at each of the demand points.
By using 'ks' as an argument in \code{kernel.method}, the volume is fit as a minimum convex polygon using \code{\link[adehabitatHR]{mcp}} and 
\code{\link[ks]{kde}} is used to fit the kernel. Note this can only be used when the data is low-dimensional (d<3). By using
'hypervolume' as an argument, the \code{\link[hypervolume]{hypervolume}} function is used. This can be used for hyper-dimensional data.
}
\examples{
data(cs_spp, cs_space)
# generate species points
species.points <- randomPoints(cs_spp[[1]], n=100, prob=TRUE)
env.points <- extract(cs_space, species.points)
# generate demand points for a 1d space using ks
dps1 <- make.DemandPoints(
points=env.points[,1],
kernel.method='ks'
)
# generate demand points for a 2d space using hypervolume
dps2 <- make.DemandPoints(
points=env.points,
kernel.method='hypervolume'
)
}
\seealso{
\code{\link[hypervolume]{hypervolume}}, \code{\link[ks]{kde}}, \code{\link[adehabitatHR]{mcp}}.
}

