% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapData.R, R/RapSolved.R
\name{prob.subset}
\alias{prob.subset}
\alias{prob.subset.RapData}
\alias{prob.subset.RapUnsolOrSol}
\title{Subset probabilities above a threshold}
\usage{
prob.subset(x, species, threshold)

\method{prob.subset}{RapData}(x, species, threshold)

\method{prob.subset}{RapUnsolOrSol}(x, species, threshold)
}
\arguments{
\item{x}{\code{RapData}, \code{RapUnsolved}, or \code{RapSolved} object.}

\item{species}{\code{integer} vector to specify the index of the species to apply threshold to}

\item{threshold}{\code{numeric} probability to use a threshold.}
}
\value{
\code{RapData} or \code{RapUnsolved} object depending on input object.
}
\description{
This function subsets out probabilities assigned to planning units above a threshold. It effectively sets the probability
that species inhabit planning units to zero if they are below the threshold.
}
\examples{
# load data
data(sim_ru)
# generate new object with first 10 planning units
sim_ru2 <- prob.subset(sim_ru, 1:3, c(0.1,0.2,0.3))
}
\seealso{
\code{RapData}, \code{RapUnsolved}, \code{RapSolved}.
}

