% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapResults.R, R/RapSolved.R
\name{selections}
\alias{selections}
\alias{selections.RapResults}
\alias{selections.RapSolved}
\title{Extract solution selections}
\usage{
selections(x, y)

\method{selections}{RapResults}(x, y = 0)

\method{selections}{RapSolved}(x, y = 0)
}
\arguments{
\item{x}{\code{\link{RapResults}} or \code{\link{RapSolved}} object.}

\item{y}{\code{NULL} to return all values, \code{integer} 0 to return values
for the best solution, \code{integer} value greater than 0 for \code{y}'th
solution value.}

\item{...}{not used.}
}
\value{
\code{\link[base]{matrix}} or \code{numeric} vector depending on
  arguments.
}
\description{
Extract selections for a given solution from a \code{\link{RapResults}} or
\code{\link{RapSolved}} object.
}
\examples{
# load data
data(sim_rs)

# selections for the best solution
selections(sim_rs, 0)

# selections for the second solution
selections(sim_rs, 2)

# selections for each solution
selections(sim_rs)

}
\seealso{
\code{\link{RapResults}}, \code{\link{RapSolved}}.
}
