% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RapResults.R
\name{RapResults}
\alias{RapResults}
\title{Create RapResults object}
\usage{
RapResults(summary, selections, amount.held, space.held, logging.file,
  .cache = new.env())
}
\arguments{
\item{summary}{\code{\link[base]{data.frame}} with summary information on
solutions. See details below for more information.}

\item{selections}{\code{\link[base]{matrix}} with binary selections. The
cell \eqn{x_{ij}} denotes if planning unit \eqn{j} is selected in the
\eqn{i}'th solution.}

\item{amount.held}{\code{\link[base]{matrix}} with the amount held for each
species in each solution.}

\item{space.held}{\code{\link[base]{matrix}} with the proportion of
attribute space sampled for each species in each solution.}

\item{logging.file}{\code{character} Gurobi log files.}

\item{.cache}{\code{\link[base]{environment}} used to cache calculations.}
}
\value{
\code{RapResults} object
}
\description{
This function creates a new \code{\link{RapResults}} object.
}
\details{
The \code{summary} table follows Marxan conventions (summary.dat in \url{http://marxan.net/downloads/uq_marxan_web_2/module5.html}). The columns
are:
\describe{
\item{Run_Number}{The index of each solution in the object.}
\item{Status}{The status of the solution. The values in this column
correspond to outputs from the Gurobi software package (\url{http://www.gurobi.com/documentation/6.5/refman/optimization_status_codes.html}).}
\item{Score}{The objective function for the solution.}
\item{Cost}{Total cost associated with a solution.}
\item{Planning_Units}{Number of planning units selected in a solution.}
\item{Connectivity_Total}{The total amount of shared boundary length between
all planning units. All solutions in the same object should have equal
values for this column.}
\item{Connectivity_In}{The amount of shared boundary length among planning
units selected in the solution.}
\item{Connectivity_Edge}{The amount of exposed boundary length in the
solution.}
\item{Connectivity_Out}{The number of shared boundary length among planning
units not selected in the solution.}
\item{Connectivity_Fraction}{The ratio of shared boundary length in the
solution (\code{Connectivity_In}) to the total amount of boundary length
(\code{Connectivity_Edge}). This ratio is an indicator of solution quality.
Solutions with a lower ratio will have less planning units and will be more
efficient.}
}
}
\note{
slot \code{best} is automatically determined based on data in
  \code{summary}.
}
\seealso{
\code{\link{RapResults-class}} \code{\link{read.RapResults}}.
}
