% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RapResults.R
\docType{class}
\name{RapResults-class}
\alias{RapResults-class}
\title{RapResults: An S4 class to represent RAP results}
\description{
This class is used to store RAP results.
}
\details{
The \code{summary} table follows Marxan conventions
(\url{https://marxansolutions.org/}). The columns
are:
\describe{
\item{Run_Number}{The index of each solution in the object.}
\item{Status}{The status of the solution. The values in this column
correspond to outputs from the Gurobi software package (\url{https://www.gurobi.com/documentation/6.5/refman/optimization_status_codes.html}).}
\item{Score}{The objective function for the solution.}
\item{Cost}{Total cost associated with a solution.}
\item{Planning_Units}{Number of planning units selected in a solution.}
\item{Connectivity_Total}{The total amount of shared boundary length between
all planning units. All solutions in the same object should have equal
values for this column.}
\item{Connectivity_In}{The amount of shared boundary length among planning
units selected in the solution.}
\item{Connectivity_Edge}{The amount of exposed boundary length in the
solution.}
\item{Connectivity_Out}{The number of shared boundary length among planning
units not selected in the solution.}
\item{Connectivity_Fraction}{The ratio of shared boundary length in the
solution (\code{Connectivity_In}) to the total amount of boundary length
(\code{Connectivity_Edge}). This ratio is an indicator of solution quality.
Solutions with a lower ratio will have less planning units and will be more
efficient.}
}
}
\section{Slots}{

\describe{
\item{\code{summary}}{\code{\link[base:data.frame]{base::data.frame()}} with summary information on
solutions.}

\item{\code{selections}}{\code{\link[base:matrix]{base::matrix()}} with binary selections. The cell
\eqn{x_{ij}} denotes if planning unit \eqn{j} is selected in the
\eqn{i}'th solution.}

\item{\code{amount.held}}{\code{\link[base:matrix]{base::matrix()}} with the amount held for each
species in each solution.}

\item{\code{space.held}}{\code{\link[base:matrix]{base::matrix()}} with the proportion of attribute
space sampled for each species in each solution.}

\item{\code{best}}{\code{integer} with index of best solution.}

\item{\code{logging.file}}{\code{character} Gurobi log files.}

\item{\code{.cache}}{\code{\link[base:environment]{base::environment()}} used to store extra data.}
}}

\seealso{
\code{\link[=RapResults]{RapResults()}}, \code{\link[=read.RapResults]{read.RapResults()}}.
}
