% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/sim.space.R
\name{sim.space}
\alias{sim.space}
\alias{sim.space.RasterLayer}
\alias{sim.space.SpatialPolygons}
\title{Simulate attribute space data for RAP}
\usage{
sim.space(x, ...)

\method{sim.space}{RasterLayer}(x, d = 2, model = 0.2, ...)

\method{sim.space}{SpatialPolygons}(x, res, d = 2, model = 0.2, ...)
}
\arguments{
\item{x}{\code{\link[raster:raster]{raster::raster()}} or
\code{\link[sp:SpatialPolygons]{sp::SpatialPolygons()}} object delineate the spatial extent to
delineate study area.}

\item{...}{not used.}

\item{d}{\code{integer} number of dimensions. Defaults to 2.}

\item{model}{\code{numeric} scale parameter for simulating spatially
auto-correlated data using Gaussian random fields.
Higher values produce patchier data with more well defined clusters,
and lower values produce more evenly distributed data.
Defaults to 0.2.}

\item{res}{\code{numeric} resolution to simulate distributions. Only needed
when \code{\link[sp:SpatialPolygons]{sp::SpatialPolygons()}} are supplied.}
}
\value{
\code{\link[raster:stack]{raster::stack()}} with layers for each dimension of the space.
}
\description{
This function simulates attribute space data for RAP.
}
\examples{
# simulate planning units
sim_pus <- sim.pus(225L)

# simulate 1d space using RasterLayer
s1 <- sim.space(blank.raster(sim_pus, 1), d = 1)

# simulate 1d space using SpatialPolygons
s2 <- sim.space(sim_pus, res = 1, d = 1)

# simulate 2d space using SpatialPolygons
s3 <- sim.space(sim_pus, res = 1, d = 2)

# plot simulated spaces
par(mfrow = c(2,2))
plot(s1, main = "s1")
plot(s2, main = "s2")
plot(s3[[1]], main = "s3: first dimension")
plot(s3[[2]], main = "s3: second dimension")

}
