% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare.group.R
\name{group.plot}
\alias{group.plot}
\title{Visualize groups by coloring branches and leaves of an hclust tree}
\usage{
group.plot(beta, gamma, A, hc, nbreaks = 20)
}
\arguments{
\item{beta}{Length-\code{nvars} vector of covariate coefficient.}

\item{gamma}{Length-\code{nnodes} vector of latent variable coefficient. Note that \code{\link{rarefit}}
returns \code{NA} as \code{gamma} value when \code{alpha} is zero,
in which case our problem becomes the lasso on \code{beta}.}

\item{A}{\code{nvars}-by-\code{nnodes} binary matrix encoding ancestor-descendant relationships
between leaves and nodes in the tree.}

\item{hc}{An \code{hclust} tree of \code{nvars} leaves where each leaf corresponds to a covariate.}

\item{nbreaks}{Number of breaks in binning \code{beta} elements (positive part and negative part
are done separately). Each bin is associated with a color based on the magnitude and
positivity/negativity of \code{beta} elements in the bin.}
}
\description{
The function plots an \code{hclust} tree with branches and leaves colored
based on group membership. The groups span the covariate indices \{1, ..., \code{nvars}\}.
Covariates from the same group share equal coefficient (\code{beta}), and sibling
groups have different coefficients. The function determines groups based on
the sparsity in \code{gamma}. In an \code{hclust} tree with \code{beta[i]} on the
\code{i}th leaf, the branch and leaf are colored in blue, red or gray according to \code{beta[i]}
being positive, negative or zero, respectively. The larger the magnitude of \code{beta[i]} is,
the darker the color will be. So branches and leaves from the same group will have the
same color.
}
\examples{
\dontrun{
# See vignette for more details.
set.seed(100)
ts <- sample(1:length(data.rating), 400) # Train set indices
# Fit the model on train set
ourfit <- rarefit(y = data.rating[ts], X = data.dtm[ts, ], hc = data.hc, lam.min.ratio = 1e-6,
                  nlam = 20, nalpha = 10, rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
# Cross validation
ourfit.cv <- rarefit.cv(ourfit, y = data.rating[ts], X = data.dtm[ts, ],
                        rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
# Visualize the groups at optimal beta and gamma
ibest.lambda <- ourfit.cv$ibest[1]
ibest.alpha <- ourfit.cv$ibest[2]
beta.opt <- ourfit$beta[[ibest.alpha]][, ibest.lambda]
gamma.opt <- ourfit$gamma[[ibest.alpha]][, ibest.lambda] # works if ibest.alpha > 1
# Visualize the groups at optimal beta and gamma
group.plot(beta.opt, gamma.opt, ourfit$A, data.hc)
}

}
