\name{rasterToPolygons}

\alias{rasterToPolygons}

\title{ Raster to polygons conversion}

\description{
Raster to polygons conversion. Cells with NA are not converted. A function can be used to select a subset of the raster cells (by their values).
}

\usage{
rasterToPolygons(x, fun=NULL, n=4, na.rm=TRUE, digits=12)
}

\arguments{
 \item{x}{ a Raster* object }
 \item{fun}{ function to select a subset of raster values (only allowed if \code{x} has a single layer}
 \item{n}{ The number of nodes for each polygon. Only 4, 8, and 16 are allowed }
 \item{na.rm}{ If \code{TRUE}, cells with \code{NA} values in all layers are ignored }
 \item{digits}{ number of digits to round the coordinates to }
}

\details{
\code{fun} should be a simple function returning a logical value
e.g.: \code{fun=function(x){x==1}} or  \code{fun=function(x){x>3 & x<6}}
}

\value{
SpatialPolygonsDataFrame
}

\author{Robert J. Hijmans}

\examples{ 
r <- raster(nrow=18, ncol=36)
r[] <- runif(ncell(r)) * 10
r[r>8] <- NA
pol <- rasterToPolygons(r, fun=function(x){x>6})
#plot(r)
#plot(pol, add=T, col='red')
}

\keyword{ spatial }
