% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-utils.R
\name{rave-runtime-events}
\alias{rave-runtime-events}
\alias{register_rave_session}
\alias{get_default_handlers}
\alias{fire_rave_event}
\alias{get_session_by_rave_id}
\alias{get_rave_event}
\alias{open_loader}
\alias{close_loader}
\alias{watch_loader_opened}
\alias{watch_data_loaded}
\alias{current_shiny_theme}
\title{'RAVE' run-time events}
\usage{
register_rave_session(
  session = shiny::getDefaultReactiveDomain(),
  .rave_id = NULL
)

get_default_handlers(session = shiny::getDefaultReactiveDomain())

fire_rave_event(
  key,
  value,
  global = FALSE,
  force = FALSE,
  session = shiny::getDefaultReactiveDomain(),
  .internal_ok = FALSE
)

get_session_by_rave_id(rave_id)

get_rave_event(key, session = shiny::getDefaultReactiveDomain())

open_loader(session = shiny::getDefaultReactiveDomain())

close_loader(session = shiny::getDefaultReactiveDomain())

watch_loader_opened(session = shiny::getDefaultReactiveDomain())

watch_data_loaded(session = shiny::getDefaultReactiveDomain())

current_shiny_theme(default, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{session}{shiny session, usually automatically determined}

\item{key}{event key to fire or to monitor}

\item{value}{event value}

\item{global}{whether to notify other sessions (experimental and not
recommended)}

\item{force}{whether to force firing the event even the \code{value} hasn't
changed}

\item{.internal_ok}{internally used}

\item{rave_id, .rave_id}{internally used to store unique session
identification key}

\item{default}{default value if not found}
}
\value{
See 'Details'
}
\description{
A set of preset behaviors used by 'RAVE' modules
}
\details{
These goal of these event functions is to  simplify the dashboard
logic without understanding the details or passing global variables around.
Everything starts with \code{register_rave_session}. This function registers
a unique identification to session, and adds bunch of registry to
monitor the changes of themes, built-in, and custom events. If you have
called \code{\link{module_server_common}}, then \code{register_rave_session}
has already been called.
\describe{
\item{\code{register_rave_session}}{make initial registries, must be called,
returns a list of registries}
\item{\code{fire_rave_event}}{send signals to make changes to a event;
returns nothing}
\item{\code{get_rave_event}}{watch and get the event values; must run in
shiny reactive context}
\item{\code{open_loader}}{fire an event with a special key
\code{'open_loader'} to open the data-loading panel; returns nothing}
\item{\code{close_loader}}{reset an event with a special key
\code{'open_loader'} to close the data-loading panel if possible;
returns nothing}
\item{\code{watch_loader_opened}}{watch in shiny reactive context whether
the loader is opened; returns a logical value, but raise errors when
reactive context is missing}
\item{\code{watch_data_loaded}}{watch a special event with key
\code{'data_loaded'}; returns a logical value of whether new data has been
loaded, or raise errors when reactive context is missing}
\item{\code{current_shiny_theme}}{watch and returns a list of theme
parameters, for example, light or dark theme}
}
}
\section{Built-in Events}{

The following event keys are built-in. Please do not fire them using
\code{fire_rave_event} or the 'RAVE' application might will crash
\describe{
\item{\code{'simplify_toggle'}}{toggle visibility of 'HTML' elements with
class \code{'rave-option'}}
\item{\code{'run_analysis'}}{notifies the module to run pipeline}
\item{\code{'save_pipeline'}, \code{'load_pipeline'}}{notifies the module to
save or load pipeline}
\item{\code{'data_loaded'}}{notifies the module that new data has been
loaded}
\item{\code{'open_loader'}, \code{'toggle_loader'}}{notifies the internal
server code to show or hide the data loading panel}
\item{\code{'active_module'}}{internally used to store current active
module information}
}
}

\examples{


library(shiny)
library(ravedash)

ui <- fluidPage(
  actionButton("btn", "Fire event"),
  actionButton("btn2", "Toggle loader")
)

server <- function(input, output, session) {
  # Create event registries
  register_rave_session()

  shiny::bindEvent(
    shiny::observe({
      fire_rave_event("my_event_key", Sys.time())
    }),
    input$btn,
    ignoreInit = TRUE,
    ignoreNULL = TRUE
  )
  shiny::bindEvent(
    shiny::observe({
      cat("An event fired with value:", get_rave_event("my_event_key"), "\n")
    }),
    get_rave_event("my_event_key"),
    ignoreNULL = TRUE
  )

  shiny::bindEvent(
    shiny::observe({
      if(watch_loader_opened()){
        close_loader()
      } else {
        open_loader()
      }
    }),
    input$btn2,
    ignoreInit = TRUE,
    ignoreNULL = TRUE
  )

  shiny::bindEvent(
    shiny::observe({
      cat("Loader is", ifelse(watch_loader_opened(), "opened", "closed"), "\n")
    }),
    watch_loader_opened(),
    ignoreNULL = TRUE
  )

}

if(interactive()){
  shinyApp(ui, server)
}

}
