% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{design_filter_iir}
\alias{design_filter_iir}
\title{Design an 'IIR' filter}
\usage{
design_filter_iir(
  method = c("butter", "cheby1", "cheby2", "ellip"),
  sample_rate,
  filter_order = NA,
  high_pass_freq = NA,
  high_pass_trans_freq = NA,
  low_pass_freq = NA,
  low_pass_trans_freq = NA,
  passband_ripple = 0.1,
  stopband_attenuation = 40
)
}
\arguments{
\item{method}{filter method name, choices are \code{"butter"},
\code{"cheby1"}, \code{"cheby2"}, and \code{"ellip"}}

\item{sample_rate}{sampling frequency}

\item{filter_order}{suggested filter order. Notice filters with higher orders
may become numerically unstable, hence this number is only a suggested
number. If the filter is unstable, this function will choose a lower order;
leave this input \code{NA} (default) if undecided.}

\item{high_pass_freq}{high-pass frequency; default is \code{NA} (no high-pass
filter will be applied)}

\item{high_pass_trans_freq}{high-pass frequency band-width; default
is automatically inferred from filter type.}

\item{low_pass_freq}{low-pass frequency; default is \code{NA} (no
low-pass filter will be applied)}

\item{low_pass_trans_freq}{low-pass frequency band-width; default
is automatically inferred from filter type.}

\item{passband_ripple}{allowable pass-band ripple in decibel; default is
\code{0.1}}

\item{stopband_attenuation}{minimum stop-band attenuation (in decibel) at
transition frequency; default is \code{40} dB.}
}
\value{
A filter in 'Arma' form.
}
\description{
Design an 'IIR' filter
}
\examples{

sample_rate <- 500

my_diagnose <- function(
    filter, vlines = c(8, 12), cutoffs = c(-3, -6)) {
  diagnose_filter(
    b = filter$b,
    a = filter$a,
    fs = sample_rate,
    vlines = vlines,
    cutoffs = cutoffs
  )
}

# ---- Default using butterworth to generate 8-12 bandpass filter ----

# Butterworth filter with cut-off frequency
# 7 ~ 13 (default transition bandwidth is 1Hz) at -3 dB
filter <- design_filter_iir(
  method = "butter",
  low_pass_freq = 12,
  high_pass_freq = 8,
  sample_rate = 500
)

filter

my_diagnose(filter)

## explicit bandwidths and attenuation (sharper transition)

# Butterworth filter with cut-off frequency
# passband ripple is 0.5 dB (8-12 Hz)
# stopband attenuation is 40 dB (5-18 Hz)
filter <- design_filter_iir(
  method = "butter",
  low_pass_freq = 12, low_pass_trans_freq = 6,
  high_pass_freq = 8, high_pass_trans_freq = 3,
  sample_rate = 500,
  passband_ripple = 0.5,
  stopband_attenuation = 40
)

filter

my_diagnose(filter)

# ---- cheby1 --------------------------------

filter <- design_filter_iir(
  method = "cheby1",
  low_pass_freq = 12,
  high_pass_freq = 8,
  sample_rate = 500
)

my_diagnose(filter)

# ---- cheby2 --------------------------------

filter <- design_filter_iir(
  method = "cheby2",
  low_pass_freq = 12,
  high_pass_freq = 8,
  sample_rate = 500
)

my_diagnose(filter)

# ----- ellip ---------------------------------

filter <- design_filter_iir(
  method = "ellip",
  low_pass_freq = 12,
  high_pass_freq = 8,
  sample_rate = 500
)

my_diagnose(filter)




}
