% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-notch.R
\name{notch_filter}
\alias{notch_filter}
\title{Apply 'Notch' filter}
\usage{
notch_filter(
  s,
  sample_rate,
  lb = c(59, 118, 178),
  ub = c(61, 122, 182),
  domain = 1
)
}
\arguments{
\item{s}{numerical vector if \code{domain=1} (voltage
signals), or complex vector if \code{domain=0}}

\item{sample_rate}{sample rate}

\item{lb}{filter lower bound of the frequencies to remove}

\item{ub}{filter upper bound of the frequencies to remove;
shares the same length as \code{lb}}

\item{domain}{\code{1} if the input signal is in the
time domain, \code{0} if it is in the frequency domain}
}
\value{
filtered signal in time domain (real numerical
vector)
}
\description{
Apply 'Notch' filter
}
\details{
Mainly used to remove electrical line frequencies
at 60, 120, and 180 \code{Hz}.
}
\examples{


time <- seq(0, 3, 0.005)
s <- sin(120 * pi * time) + rnorm(length(time))

# Welch periodogram shows a peak at 60Hz
pwelch(s, 200, plot = 1, log = "y")

# notch filter to remove 60Hz
s1 <- notch_filter(s, 200, lb = 59, ub = 61)
pwelch(s1, 200, plot = 2, log = "y", col = "red")


}
