% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blogdown.R
\name{blogdown}
\alias{blogdown}
\title{Retrieve raw R code from a blogdown web page}
\usage{
blogdown(url, method, padding)
}
\arguments{
\item{url}{Link to a blogdown web page}

\item{method}{Not all websites are formatted consistently. To overcome this, try a different
method by setting the method
parameter to integers 2 and greater to try other available methods}

\item{padding}{Specify what goes between the last character of one code block and the
first character of the next code block. Default is a two new lines, which appears
visually as one new line between code blocks.}
}
\value{
A character vector of length 1 containing the R code from the target url.
    Code from other languages (e.g. javascript, bash, or python) will also be returned if
    present.
}
\description{
Retrieve raw R code from a blogdown web page
}
\examples{
library(dplyr)
blogdown("https://www.jtimm.net/2019/04/14/lexical-change-procrustes/")

# Same as above but provided to cat for easy viewing
blogdown("https://www.jtimm.net/2019/04/14/lexical-change-procrustes/")  \%>\%
  cat

}
