% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_triangle}
\alias{csg_triangle}
\title{CSG Triangle}
\usage{
csg_triangle(v1 = c(0, 1, 0), v2 = c(1, 0, 0), v3 = c(-1, 0, 0))
}
\arguments{
\item{v1}{Default `c(0,1,0)`. First vertex.}

\item{v2}{Default `c(1,0,0)`. Second vertex.}

\item{v3}{Default `c(-1,0,0)`. Third vertex.}
}
\value{
List describing the triangle in the scene.
}
\description{
CSG Triangle
}
\examples{
\donttest{
#Generate a basic triangle:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_triangle(),material=diffuse(color="red"))) \%>\% 
  add_object(sphere(y=5,z=3,material=light(intensity=30))) \%>\% 
  render_scene(clamp_value=10,fov=20)
  
#Change a vertex:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_triangle(v1 = c(1,1,0)),material=diffuse(color="green"))) \%>\% 
  add_object(sphere(y=5,z=3,material=light(intensity=30))) \%>\% 
  render_scene(clamp_value=10,fov=20)
  
#Change all three vertices:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_triangle(v1 = c(0.5,1,0), v2 = c(1,-0.5,0), v3 = c(-1,0.5,0)),
                        material=diffuse(color="blue"))) \%>\% 
  add_object(sphere(y=5,z=3,material=light(intensity=30))) \%>\% 
  render_scene(clamp_value=10,fov=20,lookfrom=c(0,5,10))
}
}
