% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{add_lines}
\alias{add_lines}
\title{Add Line}
\usage{
add_lines(lines, line)
}
\arguments{
\item{lines}{Existing lines or empty (0-row) matrix.}

\item{line}{Line to add, generated with `generate_line()`}
}
\value{
New line matrix.
}
\description{
Add Line
}
\examples{
#Generate a cube out of lines
\donttest{
cube_outline = generate_line(start = c(-1, -1, -1), end = c(-1, -1, 1)) \%>\%
  add_lines(generate_line(start = c(-1, -1, -1), end = c(-1, 1, -1))) \%>\%
  add_lines(generate_line(start = c(-1, -1, -1), end = c(1, -1, -1))) \%>\%
  add_lines(generate_line(start = c(-1, -1, 1), end = c(-1, 1, 1))) \%>\%
  add_lines(generate_line(start = c(-1, -1, 1), end = c(1, -1, 1))) \%>\%
  add_lines(generate_line(start = c(-1, 1, 1), end = c(-1, 1, -1))) \%>\%
  add_lines(generate_line(start = c(-1, 1, 1), end = c(1, 1, 1))) \%>\%
  add_lines(generate_line(start = c(1, 1, -1), end = c(1, -1, -1))) \%>\%
  add_lines(generate_line(start = c(1, 1, -1), end = c(1, 1, 1))) \%>\%
  add_lines(generate_line(start = c(1, -1, -1), end = c(1, -1, 1))) \%>\%
  add_lines(generate_line(start = c(1, -1, 1), end = c(1, 1, 1))) \%>\%
  add_lines(generate_line(start = c(-1, 1, -1), end = c(1, 1, -1)))
  
rasterize_lines(cube_outline,fov=90,lookfrom=c(0,0,3))
}
}
