% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{sphere_mesh}
\alias{sphere_mesh}
\title{Sphere 3D Model}
\usage{
sphere_mesh(
  position = c(0, 0, 0),
  scale = c(1, 1, 1),
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  radius = 1,
  low_poly = FALSE,
  material = material_list()
)
}
\arguments{
\item{position}{Default `c(0,0,0)`. Position of the mesh.}

\item{scale}{Default `c(1,1,1)`. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}

\item{angle}{Default `c(0,0,0)`. Angle to rotate the mesh.}

\item{pivot_point}{Default `c(0,0,0)`. Point around which to rotate the mesh.}

\item{order_rotation}{Default `c(1,2,3)`. Order to rotate the axes.}

\item{radius}{Default `1`. Radius of the sphere.}

\item{low_poly}{Default `FALSE`. If `TRUE`, will use a low-poly sphere.}

\item{material}{Default `material_list()` (default values). Specify the material of the object.}
}
\value{
List describing the mesh.
}
\description{
Sphere 3D Model
}
\examples{
\dontshow{
options("cores"=1)
}
#Generate a sphere in the cornell box.
\donttest{
generate_cornell_mesh() \%>\%
  add_shape(sphere_mesh(position = c(555/2, 555/2, 555/2), radius = 100)) \%>\%
  rasterize_scene(light_info = directional_light(c(0,0.5,-1)))
}

#Generate a shiny sphere in the cornell box
\donttest{
generate_cornell_mesh() \%>\%
  add_shape(sphere_mesh(position = c(555/2, 100, 555/2), radius = 100, 
                    material = material_list(diffuse = "gold",type="phong"))) \%>\%
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}

#Generate an ellipsoid in the cornell box
\donttest{
generate_cornell_mesh() \%>\%
  add_shape(sphere_mesh(position = c(555/2, 210, 555/2), radius = 100, 
                        angle=c(0,30,0), scale = c(0.5,2,0.5),
                        material = material_list(diffuse = "dodgerblue",type="phong"))) \%>\%
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}
}
