% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrate.R
\name{accrate.age.ghost}
\alias{accrate.age.ghost}
\title{Plot a core's accumulation rates against calendar time.}
\usage{
accrate.age.ghost(
  set = get("info"),
  age.lim = c(),
  age.lab = c(),
  kcal = FALSE,
  age.res = 400,
  acc.res = 200,
  cutoff = 0.001,
  dark = 1,
  rgb.scale = c(0, 0, 0),
  rgb.res = 100,
  prob = 0.95,
  plot.range = TRUE,
  range.col = grey(0.5),
  range.lty = 2,
  plot.mean = TRUE,
  mean.col = "red",
  mean.lty = 2,
  plot.median = TRUE,
  median.col = "blue",
  median.lty = 2,
  acc.lim = c(),
  acc.lab = c(),
  BCAD = set$BCAD,
  cmyr = FALSE,
  rotate.axes = FALSE,
  rev.age = FALSE,
  rev.acc = FALSE,
  xaxs = "i",
  yaxs = "i",
  bty = "l"
)
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{age.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{age.lim=c()}).}

\item{age.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{kcal}{Use kcal BP. Default is \code{kcal=FALSE}.}

\item{age.res}{Resolution or amount of greyscale pixels to cover the age scale of the plot. Default \code{age.res=400}.}

\item{acc.res}{Resolution or amount of greyscale pixels to cover the accumulation rate scale plot. Default \code{age.res=400}.}

\item{cutoff}{Point below which colours will no longer be printed. Default \code{cutoff=0.001}.}

\item{dark}{The darkest grey value is dark=1 by default; lower values will result in lighter grey but values >1 are not advised.}

\item{rgb.scale}{The function to produce a coloured representation of all age-models. Needs 3 values for the intensity of red, green and blue. Defaults to grey-scales: \code{rgb.scale=c(0,0,0)}, but could also be, say, scales of red (\code{rgb.scale=c(1,0,0)}).}

\item{rgb.res}{Resolution of the colour spectrum depicting the age-depth model. Default \code{rgb.res=100}.}

\item{prob}{Probability ranges. Defaults to \code{prob=0.95}.}

\item{plot.range}{If \code{plot.range=TRUE}, the confidence ranges (two-tailed; half of the probability at each side) are plotted.}

\item{range.col}{Colour of the confidence ranges.}

\item{range.lty}{Line type of the confidence ranges.}

\item{plot.mean}{If \code{plot.mean=TRUE}, the means are plotted.}

\item{mean.col}{Colour of the mean accumulation rates.}

\item{mean.lty}{Type of the mean lines.}

\item{plot.median}{If \code{plot.mean=TRUE}, the medians are plotted.}

\item{median.col}{Colour of the median accumulation rates.}

\item{median.lty}{Type of the median lines.}

\item{acc.lim}{Axis limits for the accumulation rates.}

\item{acc.lab}{Axis label for the accumulation rate.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{cmyr}{Accumulation rates can be calculated in cm/year or year/cm. By default \code{cmyr=FALSE} and accumulation rates are calculated in year per cm. Axis limits are difficult to calculate when \code{cmyr=TRUE}, so a manual adaptation of \code{acc.lim} might be a good idea.}

\item{rotate.axes}{The default is to plot the calendar age horizontally and accumulation rates vertically. Change to \code{rotate.axes=TRUE} value to rotate axes.}

\item{rev.age}{The direction of the age axis, which can be reversed using \code{rev.age=TRUE}.}

\item{rev.acc}{The direction of the accumulation rate axis, which can be reversed (\code{rev.acc=TRUE}.}

\item{xaxs}{Extension of the x-axis. White space can be added to the vertical axis using \code{xaxs="r"}.}

\item{yaxs}{Extension of the y-axis. White space can be added to the vertical axis using \code{yaxs="r"}.}

\item{bty}{Type of box to be drawn around the plot (\code{"n"} for none, and \code{"l"} (default), \code{"7"}, \code{"c"}, \code{"u"}, or \code{"o"} for correspondingly shaped boxes).}
}
\value{
A greyscale plot of accumulation rate against calendar age, and (invisibly) the list of ages and their accumulation rates (ranges, medians, means).
}
\description{
Plot a grey-scale representation of a core's estimated accumulation rates against time.
}
\details{
Calculating accumulation rates against calendar age will take some time to calculate, and might show unexpected
rates around the core's maximum ages (only a few of all age-model iterations will reach such ages and they will tend to have
 modelled accumulation rates for the lower depths much lower than the other iterations). Axis limits for accumulation rates
  are estimated automatically, however upper limits can be very variable (and thus hard to predict) if calculated in \code{cm/yr}.
 Therefore you might want to manually adapt the axis limits after plotting with default settings (e.g., \code{acc.lim=c(0,1)}). See also \code{accrate.depth.ghost}, \code{accrate.depth} and \code{accrate.age}.
The grey-scale reconstruction around the oldest ages of any reconstruction often indicates very low accumulation rates.
This is due to only some MCMC iterations reaching those old ages, and these iterations will have modelled very slow accumulation rates.
Currently does not deal well with hiatuses, so do not interpret accumulation rates close to depths with inferred hiatuses.
}
\examples{
\dontrun{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth(age.res=20, d.res=20, d.by=10)
  layout(1)
  tmp <- accrate.age.ghost(age.res=200, acc.res=100)
  head(tmp)
}
}
\author{
Maarten Blaauw, J. Andres Christen
}
