% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calib.plot}
\alias{calib.plot}
\title{Plot the dates}
\usage{
calib.plot(
  set = get("info"),
  dets = set$dets,
  accordion = c(),
  BCAD = set$BCAD,
  cc = set$cc,
  rotate.axes = FALSE,
  rev.d = FALSE,
  rev.age = FALSE,
  rev.yr = rev.age,
  age.lim = c(),
  yr.lim = age.lim,
  date.res = 100,
  d.lab = c(),
  age.lab = c(),
  yr.lab = age.lab,
  height = 1,
  calheight = 1,
  mirror = TRUE,
  up = TRUE,
  cutoff = 0.1,
  C14.col = rgb(0, 0, 1, 0.5),
  C14.border = rgb(0, 0, 1, 0.75),
  cal.col = rgb(0, 0.5, 0.5, 0.5),
  cal.border = rgb(0, 0.5, 0.5, 0.75),
  dates.col = c(),
  slump.col = grey(0.8),
  new.plot = TRUE,
  plot.dists = TRUE,
  same.heights = FALSE
)
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{dets}{The set of determinations to be plotted.}

\item{accordion}{If depths have to be squeezed/stretched, the parameters can be set here. Defaults to being empty, but requires 2 parameters if active, e.g., \code{accordion=c(10,20)}.}

\item{BCAD}{The calendar scale of graphs is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{cc}{Calibration curve to be used (defaults to info$cc)}

\item{rotate.axes}{The default of plotting age on the horizontal axis and event probability on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{rev.d}{The direction of the depth axis can be reversed from the default (\code{rev.d=TRUE}).}

\item{rev.age}{The direction of the calendar age axis can be reversed from the default (\code{rev.age=TRUE})}

\item{rev.yr}{Deprecated - use rev.age instead}

\item{age.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{age.lim=c()}).}

\item{yr.lim}{Deprecated - use age.lim instead}

\item{date.res}{Date distributions are plotted using \code{date.res=100} points by default.}

\item{d.lab}{The labels for the depth axis. Default \code{d.lab="Depth (cm)"}.}

\item{age.lab}{The labels for the calendar axis (default \code{yr.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{yr.lab}{Deprecated - use age.lab instead}

\item{height}{The heights of the distributions of the dates. See also \code{normalise.dists}.}

\item{calheight}{Multiplier for the heights of the distributions of dates on the calendar scale. Defaults to \code{calheight=1}.}

\item{mirror}{Plot the dates as 'blobs'. Set to \code{mirror=FALSE} to plot simple distributions.}

\item{up}{Directions of distributions if they are plotted non-mirrored. Default \code{up=TRUE}.}

\item{cutoff}{Avoid plotting very low probabilities of date distributions (default \code{cutoff=0.1}).}

\item{C14.col}{Colour of the calibrated distributions of the dates. Default is semi-transparent blue: \code{rgb(0,0,1,.35)}.}

\item{C14.border}{Colours of the borders of calibrated 14C dates. Default is transparent dark blue: cal.col}

\item{cal.col}{Colour of the non-14C dates in the age-depth plot: default semi-transparent blue-green: \code{rgb(0,.5,.5,.35)}.}

\item{cal.border}{Colour of the of the border of non-14C dates in the age-depth plot: default semi-transparent dark blue-green: \code{rgb(0,.5,.5,.5)}.}

\item{dates.col}{As an alternative to colouring dates based on whether they are 14C or not, sets of dates can be coloured as, e.g., \code{dates.col=colours()[2:100]}.}

\item{slump.col}{Colour of slumps. Defaults to \code{slump.col=grey(0.8)}.}

\item{new.plot}{Start a new plot (\code{new.plot=TRUE}) or plot over an existing plot (\code{new.plot=FALSE}).}

\item{plot.dists}{Plot the distributions of the dates (default \code{plot.dists=TRUE}).}

\item{same.heights}{Plot the distributions of the dates all at the same maximum height (default \code{same.height=FALSE}), which instead normalises the distributions (all have an area of 1).}
}
\value{
NA
}
\description{
Produce a plot of the dated depths and their dates
}
\details{
This function is generally called internally to produce the age-depth graph.
It can be used to produce custom-built graphs.
}
\examples{
  Bacon(run=FALSE, coredir=tempfile())
  calib.plot()
}
\author{
Maarten Blaauw, J. Andres Christen
}
