/*
# Copyright (c) 2021 Reed A. Cartwright <reed@cartwright.ht>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
*/

#ifndef FRAGMITES_SUBCHUNK_H
#define FRAGMITES_SUBCHUNK_H

#include <Rinternals.h>

SEXP R_read_subchunk_blocks(SEXP r_value);
SEXP R_write_subchunk_blocks(SEXP r_values, SEXP r_palettes, SEXP r_version,
                             SEXP r_offset);

SEXP R_read_chunk_biomes(SEXP r_value);
SEXP R_write_chunk_biomes(SEXP r_values, SEXP r_palettes);

SEXP read_subchunk_palette_ids(const unsigned char **buffer,
                               const unsigned char *end, bool *nbt_palette,
                               int *palette_size);

#endif
