% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_orthology}
\alias{rba_reactome_orthology}
\title{Get Orthologous (Computationally Inferred) Events}
\usage{
rba_reactome_orthology(event_ids, species_dbid, ...)
}
\arguments{
\item{event_ids}{Human Reactome event ID(s) to retrieve their orthologous
events.}

\item{species_dbid}{Reactome database ID (DbId) of the target species. (e.g
Mus musculus is 48892). See
 \code{\link{rba_reactome_species}} or
 \href{https://reactome.org/content/schema/objects/Species/}{Reactome
 Data Schema: Entries: Species}.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List containing found Orthologous event(s) in your supplied species
  and their pertinent information.
}
\description{
Reactome incorporate manually curated human reactions and PANTHER's
  protein homology data to Computationally infer events in other eukaryotic
  species.
}
\details{
In version 73 (11 June 2020), using an orthology-based approach,
  Homo sapiens events was projected to 18,654 orthologous pathways (with
  81,835 orthologous proteins) in 15 non-human species.
  \cr See \href{https://reactome.org/documentation/inferred-events/}{
  Reactome Computationally Inferred Events} for more information.
}
\section{Corresponding API Resources}{

 "POST https://reactome.org/ContentService/data/orthologies/ids/
   species/{speciesId}"
}

\examples{
\donttest{
rba_reactome_orthology(event_ids = c("R-HSA-6799198", " R-HSA-72764"),
    species_dbid = 49633)
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
\code{\link{rba_reactome_analysis_species}}
}
\concept{"Reactome Content Service - Orthology Related Queries"}
