% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\name{counts}
\alias{counts}
\title{Get the abundance counts.}
\usage{
counts(biom)
}
\arguments{
\item{biom}{A \code{BIOM} object, as returned from \link{read.biom}.}
}
\value{
A numeric matrix of the sample abundance counts in \code{biom}.
}
\description{
Get the abundance counts.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.bz2", package = "rbiom")
    biom <- read.biom(infile)
    
    counts(biom)[1:4,1:5]

}
\seealso{
Other accessor functions: 
\code{\link{info}()},
\code{\link{metadata}()},
\code{\link{nsamples}()},
\code{\link{ntaxa}()},
\code{\link{phylogeny}()},
\code{\link{sample.names}()},
\code{\link{sequences}()},
\code{\link{taxa.names}()},
\code{\link{taxa.ranks}()},
\code{\link{taxonomy}()}
}
\concept{accessor functions}
