% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tree.r
\name{read_tree}
\alias{read_tree}
\title{Read a newick formatted phylogenetic tree.}
\usage{
read_tree(src)
}
\arguments{
\item{src}{Input data as either a file path, URL, or Newick string.
Compressed (gzip or bzip2) files are also supported.}
}
\value{
A \code{phylo} class object representing the tree.
}
\description{
A phylogenetic tree is required for computing UniFrac distance matrices.
You can load a tree from a file or by providing the tree string directly.
This tree must be in Newick format, also known as parenthetic format and
New Hampshire format.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "newick.tre", package = "rbiom")
    tree <- read_tree(infile)
    
    tree <- read_tree("
        (t9:0.99,((t5:0.87,t2:0.89):0.51,(((t10:0.16,(t7:0.83,t4:0.96)
        :0.94):0.69,(t6:0.92,(t3:0.62,t1:0.85):0.54):0.23):0.74,t8:0.1
        2):0.43):0.67);")

}
\seealso{
Other phylogeny: 
\code{\link{tree_subset}()}
}
\concept{phylogeny}
