% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_table.r
\name{taxa_table}
\alias{taxa_table}
\alias{taxa_matrix}
\title{Taxa abundances per sample.}
\usage{
taxa_table(
  biom,
  rank = -1,
  taxa = 6,
  lineage = FALSE,
  md = ".all",
  unc = "singly",
  other = FALSE,
  transform = "none",
  ties = "random",
  seed = 0
)

taxa_matrix(
  biom,
  rank = -1,
  taxa = NULL,
  lineage = FALSE,
  sparse = FALSE,
  unc = "singly",
  other = FALSE,
  transform = "none",
  ties = "random",
  seed = 0
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{rank}{What rank(s) of taxa to display. E.g. \code{"Phylum"},
\code{"Genus"}, \code{".otu"}, etc. An integer vector can also be
given, where \code{1} is the highest rank, \code{2} is the second
highest, \code{-1} is the lowest rank, \code{-2} is the second
lowest, and \code{0} is the OTU "rank". Run \code{biom$ranks} to
see all options for a given rbiom object. Default: \code{-1}.}

\item{taxa}{Which taxa to display. An integer value will show the top n
most abundant taxa. A value 0 <= n < 1 will show any taxa with that
mean abundance or greater (e.g. \code{0.1} implies >= 10\%). A
character vector of taxa names will show only those named taxa.
Default: \code{6}.}

\item{lineage}{Include all ranks in the name of the taxa. For instance,
setting to \code{TRUE} will produce
\verb{Bacteria; Actinobacteria; Coriobacteriia; Coriobacteriales}.
Otherwise the taxa name will simply be \code{Coriobacteriales}. You
want to set this to TRUE when \code{unc = "asis"} and you have taxa
names (such as \emph{Incertae_Sedis}) that map to multiple higher
level ranks. Default: \code{FALSE}}

\item{md}{Dataset field(s) to include in the output data frame, or \code{'.all'}
to include all metadata fields. Default: \code{'.all'}}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}

\item{other}{Sum all non-itemized taxa into an "Other" taxa. When
\code{FALSE}, only returns taxa matched by the \code{taxa}
argument. Specifying \code{TRUE} adds "Other" to the returned set.
A string can also be given to imply \code{TRUE}, but with that
value as the name to use instead of "Other".
Default: \code{FALSE}}

\item{transform}{Transformation to apply. Options are:
\code{c("none", "rank", "log", "log1p", "sqrt", "percent")}. \code{"rank"} is
useful for correcting for non-normally distributions before applying
regression statistics. Default: \code{"none"}}

\item{ties}{When \code{transform="rank"}, how to rank identical values.
Options are: \code{c("average", "first", "last", "random", "max", "min")}.
See \code{rank()} for details. Default: \code{"random"}}

\item{seed}{Random seed for permutations. Must be a non-negative integer.
Default: \code{0}}

\item{sparse}{If \code{TRUE}, returns a
\code{\link[slam:matrix]{slam::simple_triplet_matrix()}}, otherwise returns a
normal R matrix object. Default: \code{FALSE}}
}
\value{
\describe{
\item{\code{taxa_matrix()} - }{
A numeric matrix with taxa as rows, and samples as columns. }
\item{\code{taxa_table()} - }{
A tibble data frame with column names .sample, .taxa, .abundance, and any requested by \code{md}. }
}
}
\description{
\describe{
\item{\code{taxa_matrix()} - }{ Accepts a single \code{rank} and returns a matrix. }
\item{\code{taxa_table()} - }{ Can accept more than one \code{rank} and returns a tibble data.frame.  }
}
}
\examples{
    library(rbiom)
    
    hmp50$ranks
    
    taxa_matrix(hmp50, 'Phylum')[1:4,1:6]
    
    taxa_table(hmp50, 'Phylum')
}
\seealso{
Other taxa_abundance: 
\code{\link{sample_sums}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_clusters}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stacked}()},
\code{\link{taxa_stats}()},
\code{\link{taxa_sums}()}
}
\concept{taxa_abundance}
