% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{adjust_trajectories}
\alias{adjust_trajectories}
\title{Adjust trajectories due to the intercurrent event (ICE)}
\usage{
adjust_trajectories(
  distr_pars_group,
  outcome,
  ids,
  ind_ice,
  strategy_fun,
  distr_pars_ref = NULL
)
}
\arguments{
\item{distr_pars_group}{Named list containing the simulation parameters of the multivariate
normal distribution assumed for the given treatment group. It contains the following elements:
\itemize{
\item \code{mu}: Numeric vector indicating the mean outcome trajectory. It should include the outcome
at baseline.
\item \code{sigma} Covariance matrix of the outcome trajectory.
}}

\item{outcome}{Numeric variable that specifies the longitudinal outcome.}

\item{ids}{Factor variable that specifies the id of each subject.}

\item{ind_ice}{A binary variable that takes value \code{1} if the corresponding outcome is affected
by the ICE and \code{0} otherwise.}

\item{strategy_fun}{Function implementing trajectories after the intercurrent event (ICE). Must
be one of \code{\link[=getStrategies]{getStrategies()}}. See \code{\link[=getStrategies]{getStrategies()}} for details.}

\item{distr_pars_ref}{Optional. Named list containing the simulation parameters of the
reference arm. It contains the following elements:
\itemize{
\item \code{mu}: Numeric vector indicating the mean outcome trajectory assuming no ICEs. It should
include the outcome at baseline.
\item \code{sigma} Covariance matrix of the outcome trajectory assuming no ICEs.
}}
}
\value{
A numeric vector containing the adjusted trajectories.
}
\description{
Adjust trajectories due to the intercurrent event (ICE)
}
\seealso{
\code{\link[=adjust_trajectories_single]{adjust_trajectories_single()}}.
}
